/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.layer.DeclutterMatrix;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Location
extends OMGraphicAdapter {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.layer.location.Location");
    public double lat = 0.0;
    public double lon = 0.0;
    public int xOffset = 0;
    public int yOffset = 0;
    public int x = 0;
    public int y = 0;
    public String name = null;
    public LocationHandler handler;
    public static final int DECLUTTER_LOCALLY = -1;
    public static final int DECLUTTER_ANYWHERE = -2;
    protected OMText label = null;
    protected OMGraphic location = null;
    protected String details = "";
    protected boolean showLocation = true;
    protected boolean showName = true;
    public int origYLabelOffset = 0;
    public int origXLabelOffset = 0;
    public static final int DEFAULT_SPACING = 6;
    protected int declutterLimit = -1;
    protected boolean allowDecluttering = true;
    protected int horizontalLabelBuffer = 0;
    protected int currentFontDescent = 0;

    public Location() {
    }

    public Location(double latitude, double longitude, String name, OMGraphic locationMarker) {
        this.setLocation(latitude, longitude);
        this.name = name;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Location Lat/Lon(" + latitude + ", " + longitude + ", " + name + ")");
        }
        this.location = locationMarker == null ? new OMPoint(this.lat, this.lon) : locationMarker;
        this.label = new OMText(this.lat, this.lon, 0.0f, 0.0f, name, 0);
    }

    public Location(int x, int y, String name, OMGraphic locationMarker) {
        this.setLocation(x, y);
        this.name = name;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Location XY(" + x + ", " + y + ", " + name + ")");
        }
        this.location = locationMarker == null ? new OMPoint(x, y) : locationMarker;
        this.label = new OMText(x, y, name, 0);
    }

    public Location(double latitude, double longitude, int xOffset, int yOffset, String name, OMGraphic locationMarker) {
        this.setLocation(latitude, longitude, xOffset, yOffset);
        this.name = name;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Location(" + latitude + ", " + longitude + ", offset " + this.x + ", " + this.y + ", " + name + ")");
        }
        this.location = locationMarker == null ? new OMPoint(this.lat, this.lon, xOffset, yOffset) : locationMarker;
        this.label = new OMText(this.lat, this.lon, (float)xOffset, yOffset, name, 0);
    }

    public void setLocation(double latitude, double longitude) {
        this.lat = latitude;
        this.lon = longitude;
        this.origYLabelOffset = 0;
        this.origXLabelOffset = 6;
        this.setRenderType(1);
        if (this.location != null && this.label != null) {
            this.setGraphicLocations(latitude, longitude);
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        this.origYLabelOffset = y;
        this.origXLabelOffset = x + 6;
        this.setRenderType(2);
        if (this.location != null && this.label != null) {
            this.setGraphicLocations(x, y);
        }
    }

    public void setLocation(double latitude, double longitude, int xOffset, int yOffset) {
        this.lat = latitude;
        this.lon = longitude;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.origYLabelOffset = yOffset;
        this.origXLabelOffset = xOffset + 6;
        this.setRenderType(3);
        if (this.location != null && this.label != null) {
            this.setGraphicLocations(latitude, longitude, xOffset, yOffset);
        }
    }

    public void setLocation(int x, int y, Projection proj) {
        int renderType = this.getRenderType();
        switch (renderType) {
            case 1: {
                if (proj != null) {
                    Object llp = proj.inverse(x, y);
                    this.setLocation((float)((Point2D)llp).getY(), (float)((Point2D)llp).getX());
                    break;
                }
                logger.fine("Location can't set lat/lon coordinates without a projection");
                break;
            }
            case 3: {
                if (proj != null) {
                    Object llp = proj.inverse(x, y);
                    this.setLocation((float)((Point2D)llp).getY(), (float)((Point2D)llp).getX(), this.xOffset, this.yOffset);
                    break;
                }
                logger.fine("Location can't set lat/lon coordinates without a projection");
                break;
            }
            default: {
                this.setLocation(x, y);
            }
        }
    }

    public abstract void setGraphicLocations(double var1, double var3);

    public abstract void setGraphicLocations(int var1, int var2);

    public abstract void setGraphicLocations(double var1, double var3, int var5, int var6);

    public void setLocationHandler(LocationHandler lh) {
        this.handler = lh;
    }

    public LocationHandler getLocationHandler() {
        return this.handler;
    }

    public void setLocationPaint(Paint locationPaint) {
        if (this.location != null) {
            this.location.setLinePaint(locationPaint);
        }
    }

    public OMText getLabel() {
        return this.label;
    }

    public void setLabel(OMText lable) {
        this.label = lable;
    }

    public OMGraphic getLocationMarker() {
        return this.location;
    }

    public void setLocationMarker(OMGraphic graphic) {
        this.location = graphic;
    }

    public void setShowLocation(boolean showLocations) {
        this.showLocation = showLocations;
    }

    public boolean isShowLocation() {
        return this.showLocation;
    }

    public void setShowName(boolean showNames) {
        this.showName = showNames;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.label != null) {
            this.label.setData(name);
        }
    }

    public void setDetails(String det) {
        this.details = det;
    }

    public String getDetails() {
        return this.details;
    }

    public void showDetails() {
        if (this.details != null) {
            try {
                this.getLocationHandler().getLayer().fireRequestBrowserContent(this.details);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setAllowDecluttering(boolean allow) {
        this.allowDecluttering = allow;
    }

    public boolean isAllowDecluttering() {
        return this.allowDecluttering;
    }

    public void setHorizontalLabelBuffer(int buffer) {
        this.horizontalLabelBuffer = buffer;
    }

    public int getHorizontalLabelBuffer() {
        return this.horizontalLabelBuffer;
    }

    public boolean generate(Projection proj, DeclutterMatrix declutterMatrix) {
        boolean ret = this.generate(proj);
        if (declutterMatrix != null && this.label != null && this.allowDecluttering) {
            this.declutterLabel(declutterMatrix, proj);
        }
        return ret;
    }

    public void setDeclutterLimit(int value) {
        this.declutterLimit = value < 0 && value != -1 ? -2 : value;
    }

    public int getDeclutterLimit() {
        return this.declutterLimit;
    }

    public boolean generate(Projection proj) {
        Graphics2D g;
        if (this.label != null) {
            this.label.setY(this.origYLabelOffset);
            this.label.setX(this.origXLabelOffset);
        }
        if ((g = DeclutterMatrix.getGraphics()) != null && this.label != null) {
            g.setFont(this.label.getFont());
            int height = g.getFontMetrics().getAscent();
            this.currentFontDescent = g.getFontMetrics().getDescent();
            this.label.setX(this.label.getX() + this.horizontalLabelBuffer);
            this.label.setY(this.label.getY() + height / 2 - 2);
        }
        if (this.label != null) {
            this.label.generate(proj);
            this.label.prepareForRender(g);
        }
        if (this.location != null) {
            this.location.generate(proj);
        }
        return true;
    }

    public void render(Graphics g) {
        this.renderLocation(g);
        this.renderName(g);
    }

    public void renderName(Graphics g) {
        if (this.shouldRenderName()) {
            this.label.render(g);
        }
    }

    public void renderLocation(Graphics g) {
        if (this.shouldRenderLocation()) {
            this.location.render(g);
        }
    }

    protected boolean shouldRenderName() {
        boolean globalShowNames = false;
        boolean forceGlobal = false;
        if (this.handler != null) {
            globalShowNames = this.handler.isShowNames();
            forceGlobal = this.handler.isForceGlobal();
        }
        return this.label != null && (forceGlobal && globalShowNames || !forceGlobal && this.showName);
    }

    protected boolean shouldRenderLocation() {
        boolean globalShowLocations = false;
        boolean forceGlobal = false;
        if (this.handler != null) {
            globalShowLocations = this.handler.isShowLocations();
            forceGlobal = this.handler.isForceGlobal();
        }
        return this.location != null && (forceGlobal && globalShowLocations || !forceGlobal && this.showLocation);
    }

    public float distance(double x, double y) {
        float labelDist = Float.MAX_VALUE;
        float locationDist = Float.MAX_VALUE;
        if (this.shouldRenderLocation()) {
            locationDist = this.location.distance(x, y);
        }
        if (this.shouldRenderName()) {
            labelDist = this.label.distance(x, y);
        }
        return locationDist > labelDist ? labelDist : locationDist;
    }

    protected void declutterLabel(DeclutterMatrix declutter, Projection proj) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("\nLocation::RepositionText => " + this.label.getData());
        }
        if (this.isShowName() || this.handler != null && this.handler.isShowNames()) {
            if (this.label == null || this.label.getPolyBounds() == null) {
                return;
            }
            Rectangle bounds = this.label.getPolyBounds().getBounds();
            int height = (int)(bounds.getHeight() - (double)(this.currentFontDescent / 2));
            int width = (int)bounds.getWidth();
            Point2D p = this.label.getMapLocation();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("old point X Y =>" + p.getX() + " " + p.getY() + "    height = " + height + " width = " + width);
            }
            int limit = this.declutterLimit == -1 ? height * 2 : this.declutterLimit;
            Point2D newpoint = declutter.setNextOpen(p, width, height, limit);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("new point X Y =>" + newpoint.getX() + " " + newpoint.getY());
            }
            this.label.setMapLocation(newpoint);
        }
    }

    public static float convertCoordinateString(String coord) throws NumberFormatException {
        String mantissa;
        float ret = 0.0f;
        char direction = coord.charAt(0);
        if (direction == 'N' || direction == 'S' || direction == 'n' || direction == 's') {
            float whole = new Float(coord.substring(1, 3)).floatValue();
            ret += whole;
            mantissa = coord.substring(3);
        } else if (direction == 'W' || direction == 'E' || direction == 'w' || direction == 'e') {
            ret += new Float(coord.substring(1, 4)).floatValue();
            mantissa = coord.substring(4);
        } else {
            throw new NumberFormatException("Location.convertCoordinateString wants <[NSWE]XXXXXXXX>, not getting it.");
        }
        ret += new Float(mantissa).floatValue() / (float)Math.pow(10.0, mantissa.length());
        if (direction == 'W' || direction == 'S' || direction == 'w' || direction == 's') {
            ret *= -1.0f;
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.info("  usage: java com.bbn.openmap.layer.location.Location <[NSWE]XXXXXXXX>");
            return;
        }
        float ret = Location.convertCoordinateString(args[0]);
        System.out.println(ret);
    }
}

