/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.propertyEditor.Inspector;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class LayerAddPanel
extends OMComponentPanel
implements Serializable,
ActionListener {
    public static final String layerTypes = "addableLayers";
    protected PropertyHandler propertyHandler = null;
    protected LayerHandler layerHandler = null;
    protected JComboBox list = null;
    protected JTextField prefixTextField = null;
    protected final String configureActionCommand = "configureActionCommand";
    protected Hashtable layerClasses = null;
    protected Inspector inspector = null;
    protected Object layer;
    public static final String DefaultLayerName = "Layer Name";

    public LayerAddPanel() {
        if (Debug.debugging("addable")) {
            Debug.output("LayerAddPanel()");
        }
        this.inspector = new Inspector();
        this.inspector.addActionListener(this);
    }

    public LayerAddPanel(PropertyHandler p, LayerHandler l) {
        this();
        this.propertyHandler = p;
        this.layerHandler = l;
    }

    public void createLayerClasses(Layer[] layers) {
        this.getLayerClasses().clear();
        for (int i = 0; i < layers.length; ++i) {
            this.addLayer(layers[i].getName(), layers[i].getClass().getName());
        }
    }

    public void createPanel(Layer[] layers) {
        this.createLayerClasses(layers);
        this.createPanel();
    }

    public void createPanel() {
        this.removeAll();
        JButton configureButton = new JButton(this.i18n.get(LayerAddPanel.class, "configureButton", "Configure"));
        configureButton.addActionListener(this);
        configureButton.setActionCommand("configureActionCommand");
        String defaultLayerName = this.i18n.get(LayerAddPanel.class, "defaultLayerName", DefaultLayerName);
        this.prefixTextField = new JTextField(defaultLayerName, 12);
        Object[] layerTypes = this.getLayerClasses().keySet().toArray();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(10, 10, 5, 10);
        if (layerTypes.length == 0) {
            String message = this.i18n.get(LayerAddPanel.class, "noLayersAvailableMessage", "No Layers available for creation.");
            JLabel label = new JLabel(message);
            gridbag.setConstraints(label, c);
            this.add(label);
        } else {
            this.list = new JComboBox<Object>(layerTypes);
            gridbag.setConstraints(this.list, c);
            this.add(this.list);
            c.insets = new Insets(5, 10, 10, 10);
            c.gridwidth = -1;
            gridbag.setConstraints(this.prefixTextField, c);
            this.add(this.prefixTextField);
            c.weightx = 0.0;
            gridbag.setConstraints(configureButton, c);
            this.add(configureButton);
        }
        this.invalidate();
    }

    public Hashtable getLayerClasses() {
        if (this.layerClasses == null) {
            this.layerClasses = new Hashtable();
        }
        return this.layerClasses;
    }

    public void addLayer(String prettyName, String className) {
        this.getLayerClasses().put(prettyName, className);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        if (Debug.debugging("addable")) {
            Debug.output("LayerAddPanel.setProperties()");
        }
        this.getLayerTypes(props);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        int layerNumber = 1;
        if (this.layerClasses != null) {
            StringBuffer layerList = new StringBuffer();
            Enumeration keys = this.layerClasses.keys();
            while (keys.hasMoreElements()) {
                String prettyName = (String)keys.nextElement();
                String className = (String)this.layerClasses.get(prettyName);
                String markerName = "l" + layerNumber++;
                layerList.append(markerName).append(" ");
                props.put(markerName + ".prettyName", prettyName);
                props.put(markerName + ".class", className);
            }
            props.put("openmap.addableLayers", layerList.toString());
        }
        return props;
    }

    protected Hashtable getLayerTypes() {
        return this.getLayerTypes(null);
    }

    protected Hashtable getLayerTypes(Properties props) {
        Vector<String> typeList;
        Hashtable layerHash = this.getLayerClasses();
        layerHash.clear();
        if (props == null) {
            if (this.propertyHandler != null) {
                props = this.propertyHandler.getProperties();
            } else {
                return layerHash;
            }
        }
        String prefix = "openmap";
        String addableList = props.getProperty(prefix + "." + layerTypes);
        if (Debug.debugging("addable")) {
            Debug.output("LayerAddPanel: " + addableList);
        }
        if ((typeList = PropUtils.parseSpacedMarkers(addableList)) == null) {
            return layerHash;
        }
        int unNamedCount = 1;
        for (int i = 0; i < typeList.size(); ++i) {
            String className = props.getProperty(typeList.get(i) + ".class");
            String prettyName = props.getProperty(typeList.get(i) + ".prettyName");
            if (prettyName == null) {
                prettyName = "Layer " + unNamedCount++;
            }
            if (className == null) continue;
            if (Debug.debugging("addable")) {
                Debug.output("  adding " + className + ", " + className);
            }
            layerHash.put(prettyName, className);
        }
        return layerHash;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "configureActionCommand") {
            String prettyName = (String)this.list.getSelectedItem();
            String prefix = this.prefixTextField.getText().trim();
            if (prettyName == null) {
                return;
            }
            String newClassName = (String)this.layerClasses.get(prettyName);
            this.layer = ComponentFactory.create(newClassName);
            if (this.layer instanceof PropertyConsumer) {
                if (this.layer instanceof PlugIn) {
                    PlugInLayer pil = new PlugInLayer();
                    pil.setPlugIn((PlugIn)this.layer);
                    pil.setName(prefix);
                    this.layer = pil;
                }
                if (this.layer instanceof Layer) {
                    ((Layer)this.layer).setName(prefix);
                }
                prefix = this.propertyHandler.getUniquePrefix(prefix);
                ((PropertyConsumer)this.layer).setPropertyPrefix(prefix);
                this.inspector.inspectPropertyConsumer((PropertyConsumer)this.layer);
            }
        } else if (e.getActionCommand() == "doneCommand") {
            if (this.layer != null && this.layerHandler != null) {
                if (this.layer instanceof Layer) {
                    this.layerHandler.addLayer((Layer)this.layer, 0);
                } else if (this.layer instanceof PlugIn) {
                    PlugInLayer pil = (PlugInLayer)((PlugIn)this.layer).getComponent();
                    this.layerHandler.addLayer(pil, 0);
                }
                this.prefixTextField.setText(DefaultLayerName);
            } else if (this.layerHandler != null) {
                String message = this.i18n.get(LayerAddPanel.class, "noLayerHandlerMessage", "Layer Handler not found.\nCan't find anything to add the layer to.");
                JOptionPane.showMessageDialog(this, message);
            } else {
                String message = this.i18n.get(LayerAddPanel.class, "noLayerCreatedMessage", "No Layer instantiated.");
                JOptionPane.showMessageDialog(this, message);
            }
        } else if (e.getActionCommand() == "cancelCommand") {
            if (this.layer != null && this.propertyHandler != null) {
                this.propertyHandler.removeUsedPrefix(((PropertyConsumer)this.layer).getPropertyPrefix());
            }
        } else {
            this.showPanel();
        }
    }

    public void showPanel() {
        this.createPanel();
        this.prefixTextField.setText(DefaultLayerName);
        WindowSupport ws = this.getWindowSupport();
        MapHandler mh = (MapHandler)this.getBeanContext();
        Frame frame = null;
        if (mh != null) {
            frame = mh.get(Frame.class);
        }
        if (ws == null) {
            ws = new WindowSupport((Component)this, this.i18n.get(LayerAddPanel.class, "title", "Add Layer"));
            this.setWindowSupport(ws);
        }
        ws.displayInWindow(frame, -1, -1, -1, -1);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof PropertyHandler) {
            Debug.message("layerspanel", "LayerAddPanel found a LayerHandler");
            this.propertyHandler = (PropertyHandler)someObj;
        }
        if (someObj instanceof LayerHandler) {
            this.layerHandler = (LayerHandler)someObj;
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof PropertyHandler && this.propertyHandler == someObj) {
            Debug.message("addable", "LayerAddPanel removing PropertyHandler");
            this.propertyHandler = null;
        }
        if (someObj instanceof LayerHandler && someObj == this.layerHandler) {
            Debug.message("addable", "LayerAddPanel removing LayerHandler");
            this.layerHandler = null;
        }
    }

    public static void main(String[] args) {
        LayerAddPanel lap = new LayerAddPanel(new PropertyHandler(), null);
        Layer[] layers = new Layer[]{new ShapeLayer()};
        lap.createPanel(layers);
    }
}

