/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.gui.menu.DataBoundsViewMenuItem;
import com.bbn.openmap.gui.menu.OMBasicMenu;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GoToMenu
extends AbstractOpenMapMenu {
    private String defaultText = "Views";
    private String defaultMnemonic = "V";
    protected Hashtable dataBoundsProviders = new Hashtable();
    protected OMBasicMenu dataBoundsMenu;
    protected MapBean map;
    public static final String ViewListProperty = "views";
    public static final String NameProperty = "name";
    public static final String LatProperty = "latitude";
    public static final String LonProperty = "longitude";
    public static final String ScaleProperty = "scale";
    public static final String ProjectionTypeProperty = "projection";
    public static final String AddDefaultListProperty = "addDefaults";
    public static final String AddDataViewsProperty = "addDataViews";
    protected boolean addDefaults = true;
    protected boolean addDataViews = true;
    protected List customViews;

    public GoToMenu() {
        this.setText(this.i18n.get(this, "goto", this.defaultText));
        this.dataBoundsMenu = new OMBasicMenu(this.i18n.get(this, "goOverData", "Go Over Data"));
        this.add(new AddNewViewButton(this.i18n.get(this, "addSavedView", "Add Saved View...")));
        this.add(this.dataBoundsMenu);
        this.add(new JSeparator());
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj instanceof MapBean && this.getMap() == (MapBean)someObj) {
            this.setMap(null);
        }
        if (someObj instanceof DataBoundsProvider) {
            this.removeDataBoundsProvider((DataBoundsProvider)someObj);
        }
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MapBean) {
            this.setMap((MapBean)someObj);
        }
        if (someObj instanceof DataBoundsProvider) {
            this.addDataBoundsProvider((DataBoundsProvider)someObj);
        }
    }

    public void setMap(MapBean mb) {
        this.map = mb;
    }

    public MapBean getMap() {
        return this.map;
    }

    public void setProperties(String prefix, Properties props) {
        String locationList;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.addDefaults = PropUtils.booleanFromProperties(props, prefix + AddDefaultListProperty, this.addDefaults);
        this.addDataViews = PropUtils.booleanFromProperties(props, prefix + AddDataViewsProperty, this.addDataViews);
        this.dataBoundsMenu.setVisible(this.addDataViews);
        if (this.addDefaults) {
            this.addDefaultLocations();
            this.add(new JSeparator());
        }
        if ((locationList = props.getProperty(prefix + ViewListProperty)) != null) {
            Vector<String> views = PropUtils.parseSpacedMarkers(locationList);
            for (String viewPrefix : views) {
                this.addLocationItem(viewPrefix, props);
            }
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + AddDefaultListProperty, new Boolean(this.addDefaults).toString());
        props.put(prefix + AddDataViewsProperty, new Boolean(this.addDataViews).toString());
        StringBuffer viewList = new StringBuffer();
        for (GoToButton gtb : this.ensureCustomViews()) {
            String sanitizedName = gtb.getText().replace(' ', '_');
            viewList.append(" ").append(sanitizedName);
            sanitizedName = PropUtils.getScopedPropertyPrefix(sanitizedName);
            props.put(sanitizedName + NameProperty, gtb.getText());
            props.put(sanitizedName + LatProperty, new Float(gtb.latitude).toString());
            props.put(sanitizedName + LonProperty, new Float(gtb.longitude).toString());
            props.put(sanitizedName + ScaleProperty, new Float(gtb.scale).toString());
            props.put(sanitizedName + ProjectionTypeProperty, gtb.projectionID);
        }
        props.put(prefix + ViewListProperty, viewList.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put(ViewListProperty, "Space-separated marker list of different views");
        props.put(AddDefaultListProperty, "Flag to add default views (true/false).");
        props.put("addDefaults.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put(AddDataViewsProperty, "Flag to add views from some data components.");
        props.put("addDataViews.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        props.put(NameProperty, "The formal name of the view for the user.");
        props.put(LatProperty, "The latitude of the center of the view.");
        props.put(LonProperty, "The longitude of the center of the view.");
        props.put(ScaleProperty, "The scale of the view.");
        props.put(ProjectionTypeProperty, "The projection name of the view");
        return props;
    }

    public void addDefaultLocations() {
        this.add(new GoToButton(this.i18n.get(this, "world", "World"), 0.0f, 0.0f, Float.MAX_VALUE, "Mercator"));
    }

    protected List createCustomViews() {
        return new Vector();
    }

    public List getCustomViews() {
        return this.customViews;
    }

    public List ensureCustomViews() {
        if (this.customViews == null) {
            this.customViews = this.createCustomViews();
        }
        return this.customViews;
    }

    public void setCustomViews(List views) {
        this.customViews = views;
    }

    public void addLocationItem(String prefix, Properties props) {
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String locationName = props.getProperty(prefix + NameProperty);
        String latString = props.getProperty(prefix + LatProperty);
        String lonString = props.getProperty(prefix + LonProperty);
        String scaleString = props.getProperty(prefix + ScaleProperty);
        String projID = props.getProperty(prefix + ProjectionTypeProperty);
        if (Debug.debugging("goto")) {
            Debug.output("GoToMenu: adding view - " + locationName + ", " + latString + ", " + lonString + ", " + scaleString + ", " + projID);
        }
        try {
            float lat = new Float(latString).floatValue();
            float lon = new Float(lonString).floatValue();
            float scale = new Float(scaleString).floatValue();
            GoToButton gtb = new GoToButton(locationName, lat, lon, scale, projID);
            this.ensureCustomViews().add(gtb);
            this.add(gtb);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public void addDataBoundsProvider(DataBoundsProvider provider) {
        if (!this.dataBoundsProviders.containsKey(provider)) {
            DataBoundsViewMenuItem dbvmi = new DataBoundsViewMenuItem(provider);
            this.dataBoundsProviders.put(provider, dbvmi);
            dbvmi.findAndInit(this.getBeanContext());
            this.dataBoundsMenu.add(dbvmi);
        }
    }

    public void removeDataBoundsProvider(DataBoundsProvider provider) {
        DataBoundsViewMenuItem item = (DataBoundsViewMenuItem)this.dataBoundsProviders.remove(provider);
        if (item != null) {
            this.dataBoundsMenu.remove(item);
        }
    }

    public void addView(GoToButton newOne) {
        this.ensureCustomViews().add(newOne);
        this.add(newOne);
        this.revalidate();
    }

    public class NameFetcher
    extends JDialog
    implements ActionListener {
        JTextField nameField;
        JLabel label;
        JButton closebutton;
        JButton applybutton;
        GoToButton notifyThis;

        public NameFetcher(GoToButton buttonToName) {
            this.notifyThis = buttonToName;
            this.setTitle(GoToMenu.this.i18n.get(GoToMenu.class, "addViewTitle", "Add View"));
            JPanel palette = new JPanel();
            palette.setLayout(new BoxLayout(palette, 1));
            JPanel namePanel = new JPanel();
            namePanel.setLayout(new FlowLayout());
            this.label = new JLabel(GoToMenu.this.i18n.get(GoToMenu.class, "nameOfView", "Name of View: "));
            this.nameField = new JTextField("", 20);
            namePanel.add(this.label);
            namePanel.add(this.nameField);
            palette.add(namePanel);
            JPanel buttonPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            buttonPanel.setLayout(gridbag);
            this.applybutton = new JButton(GoToMenu.this.i18n.get(GoToMenu.class, "addView", "Add View"));
            this.applybutton.addActionListener(this);
            gridbag.setConstraints(this.applybutton, c);
            this.closebutton = new JButton(GoToMenu.this.i18n.get(GoToMenu.class, "close", "Close"));
            this.closebutton.addActionListener(this);
            c.gridx = -1;
            gridbag.setConstraints(this.closebutton, c);
            buttonPanel.add(this.applybutton);
            buttonPanel.add(this.closebutton);
            palette.add(buttonPanel);
            this.getContentPane().add(palette);
            this.pack();
        }

        public void actionPerformed(ActionEvent event) {
            String newName;
            if (event.getSource() == this.applybutton && (newName = this.nameField.getText()) != null && newName.length() != 0) {
                this.notifyThis.setNameAndAdd(newName);
            }
            this.setVisible(false);
        }
    }

    public class GoToButton
    extends JMenuItem
    implements ActionListener {
        public float latitude;
        public float longitude;
        public float scale;
        public String projectionID;
        GoToMenu menu;

        public GoToButton(String title, float lat, float lon, float s, String projID) {
            super(title);
            this.init(lat, lon, s, projID);
        }

        public GoToButton(float lat, float lon, float s, String projID) {
            this.init(lat, lon, s, projID);
            NameFetcher nf = new NameFetcher(this);
            if (GoToMenu.this.map != null) {
                Point p = GoToMenu.this.map.getLocationOnScreen();
                int x = (int)p.getX();
                int y = (int)p.getY();
                int w = GoToMenu.this.map.getWidth();
                int h = GoToMenu.this.map.getHeight();
                nf.setLocation(x + (w - nf.getWidth()) / 2, y + (h - nf.getHeight()) / 2);
            }
            nf.setVisible(true);
        }

        public void init(float lat, float lon, float s, String projID) {
            this.latitude = lat;
            this.longitude = lon;
            this.scale = s;
            this.projectionID = projID;
            this.addActionListener(this);
        }

        public void setNameAndAdd(String name) {
            this.setText(name);
            GoToMenu.this.addView(this);
        }

        public void actionPerformed(ActionEvent ae) {
            if (GoToMenu.this.map != null) {
                Projection oldProj = GoToMenu.this.map.getProjection();
                ProjectionFactory projFactory = GoToMenu.this.map.getProjectionFactory();
                Class<? extends Projection> projClass = projFactory.getProjClassForName(this.projectionID);
                if (projClass == null) {
                    projClass = Mercator.class;
                }
                Projection newProj = projFactory.makeProjection(projClass, (Point2D)new Point2D.Float(this.longitude, this.latitude), this.scale, oldProj.getWidth(), oldProj.getHeight());
                GoToMenu.this.map.setProjection(newProj);
            }
        }
    }

    public class AddNewViewButton
    extends JMenuItem
    implements ActionListener {
        public AddNewViewButton(String title) {
            super(title);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent ae) {
            if (GoToMenu.this.map != null) {
                Projection proj = GoToMenu.this.map.getProjection();
                Object llp = proj.getCenter();
                new GoToButton((float)((Point2D)llp).getY(), (float)((Point2D)llp).getX(), proj.getScale(), proj.getName());
            }
        }
    }
}

