/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.image.ImageScaler;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class OMMouseMode
extends CoordMouseMode {
    private static final long serialVersionUID = 1L;
    public static final String OpaquenessProperty = "opaqueness";
    public static final String LeaveShadowProperty = "leaveShadow";
    public static final String UseCursorProperty = "useCursor";
    public static final float DEFAULT_OPAQUENESS = 1.0f;
    public static final transient String modeID = "Gestures";
    private boolean isPanning = false;
    private int oX;
    private int oY;
    private float opaqueness = 1.0f;
    private boolean leaveShadow = false;
    private boolean useCursor;
    public Point2D rPoint1;
    public Point2D rPoint2;
    protected BufferedMapBean theMap = null;
    protected String coordString = null;

    public OMMouseMode() {
        super(modeID, true);
        this.setUseCursor(false);
        this.setLeaveShadow(true);
        this.setOpaqueness(1.0f);
    }

    public boolean isUseCursor() {
        return this.useCursor;
    }

    public void setUseCursor(boolean useCursor) {
        this.useCursor = useCursor;
        if (useCursor) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon pointer = new ImageIcon(this.getClass().getResource("Gestures.gif"));
                Dimension bestSize = tk.getBestCursorSize(pointer.getIconWidth(), pointer.getIconHeight());
                Image pointerImage = ImageScaler.getOptimalScalingImage(pointer.getImage(), (int)bestSize.getWidth(), (int)bestSize.getHeight());
                Cursor cursor = tk.createCustomCursor(pointerImage, new Point(0, 0), "PP");
                this.setModeCursor(cursor);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setModeCursor(Cursor.getPredefinedCursor(0));
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.opaqueness = PropUtils.floatFromProperties(props, prefix + OpaquenessProperty, this.opaqueness);
        this.leaveShadow = PropUtils.booleanFromProperties(props, prefix + LeaveShadowProperty, this.leaveShadow);
        this.setUseCursor(PropUtils.booleanFromProperties(props, prefix + UseCursorProperty, this.isUseCursor()));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + OpaquenessProperty, Float.toString(this.getOpaqueness()));
        props.put(prefix + LeaveShadowProperty, Boolean.toString(this.isLeaveShadow()));
        props.put(prefix + UseCursorProperty, Boolean.toString(this.isUseCursor()));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, OMMouseMode.class, OpaquenessProperty, "Transparency", "Transparency level for moving map, between 0 (clear) and 1 (opaque).", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, OMMouseMode.class, LeaveShadowProperty, "Leave Shadow", "Display current map in background while panning.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, OMMouseMode.class, UseCursorProperty, "Use Cursor", "Use hand cursor for mouse mode.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    protected BufferedMapBean getBufferedMapBean(MouseEvent evt) {
        if (evt instanceof MapMouseEvent) {
            MapBean mb = ((MapMouseEvent)evt).getMap();
            if (mb instanceof BufferedMapBean) {
                return (BufferedMapBean)mb;
            }
        } else {
            Object src = evt.getSource();
            if (src instanceof BufferedMapBean) {
                return (BufferedMapBean)src;
            }
        }
        return null;
    }

    public void mouseDragged(MouseEvent arg0) {
        super.mouseDragged(arg0);
        if (this.mouseSupport.proxy == null) {
            BufferedMapBean mb = this.getBufferedMapBean(arg0);
            if (mb == null) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(arg0)) {
                Point2D pnt = mb.getNonRotatedLocation(arg0);
                int x = (int)pnt.getX();
                int y = (int)pnt.getY();
                if (!this.isPanning) {
                    this.oX = x;
                    this.oY = y;
                    this.isPanning = true;
                } else {
                    mb.setPanningTransform(AffineTransform.getTranslateInstance(x - this.oX, y - this.oY));
                    mb.repaint();
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mouseSupport.fireMapMousePressed(e);
        e.getComponent().requestFocus();
        if (this.mouseSupport.proxy == null && SwingUtilities.isRightMouseButton(e)) {
            MapBean mb = this.theMap;
            if (mb == null && e.getSource() instanceof MapBean) {
                mb = (MapBean)e.getSource();
            }
            if (mb != null) {
                this.rPoint1 = mb.getCoordinates(e);
                this.rPoint2 = null;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object obj = e.getSource();
        boolean consumed = this.mouseSupport.fireMapMouseClicked(e);
        if (consumed || !(obj instanceof MapBean) || e.getClickCount() < 2) {
            return;
        }
        MapBean map = (MapBean)obj;
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        Point2D llp = map.getCoordinates(e);
        boolean shift = e.isShiftDown();
        if (shift) {
            p.setScale(p.getScale() * 2.0f);
        } else {
            p.setScale(p.getScale() / 2.0f);
        }
        p.setCenter(llp);
        map.setProjection(p);
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.mouseSupport.proxy == null && this.isPanning) {
            BufferedMapBean mb = this.getBufferedMapBean(arg0);
            if (mb == null) {
                return;
            }
            Projection proj = mb.getProjection();
            Point2D center = proj.forward((Point2D)proj.getCenter());
            Point2D pnt = mb.getNonRotatedLocation(arg0);
            int x = (int)pnt.getX();
            int y = (int)pnt.getY();
            center.setLocation(center.getX() - (double)x + (double)this.oX, center.getY() - (double)y + (double)this.oY);
            mb.setCenter((Point2D)proj.inverse(center));
            mb.setPanningTransform(null);
            this.isPanning = false;
        }
        super.mouseReleased(arg0);
    }

    public boolean isLeaveShadow() {
        return this.leaveShadow;
    }

    public void setLeaveShadow(boolean leaveShadow) {
        this.leaveShadow = leaveShadow;
    }

    public float getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(float opaqueness) {
        this.opaqueness = opaqueness;
    }

    public boolean isPanning() {
        return this.isPanning;
    }

    public int getOX() {
        return this.oX;
    }

    public int getOY() {
        return this.oY;
    }
}

