/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.SharedExecutorService;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.TableServiceJsonError;
import com.azure.data.tables.implementation.models.TableServiceJsonErrorException;
import com.azure.data.tables.implementation.models.TableServiceOdataError;
import com.azure.data.tables.implementation.models.TableServiceOdataErrorMessage;
import com.azure.data.tables.models.TableServiceError;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableTransactionFailedException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TableUtils {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String DELIMITER_CONTINUATION_TOKEN = ";";

    private TableUtils() {
        throw new UnsupportedOperationException("Cannot instantiate TablesUtils");
    }

    public static TableServiceError toTableServiceError(TableServiceJsonError tableServiceJsonError) {
        TableServiceOdataError odataError;
        String errorCode = null;
        String errorMessage = null;
        if (tableServiceJsonError != null && (odataError = tableServiceJsonError.getOdataError()) != null) {
            errorCode = odataError.getCode();
            TableServiceOdataErrorMessage odataErrorMessage = odataError.getMessage();
            if (odataErrorMessage != null) {
                errorMessage = odataErrorMessage.getValue();
            }
        }
        return new TableServiceError(errorCode, errorMessage);
    }

    public static TableServiceException toTableServiceException(TableServiceJsonErrorException exception) {
        return new TableServiceException(exception.getMessage(), exception.getResponse(), TableUtils.toTableServiceError(exception.getValue()));
    }

    public static Throwable mapThrowableToTableServiceException(Throwable throwable) {
        Throwable cause;
        if (throwable instanceof TableServiceJsonErrorException) {
            return TableUtils.toTableServiceException((TableServiceJsonErrorException)((Object)throwable));
        }
        if (throwable.getCause() instanceof Exception && (cause = throwable.getCause()) instanceof TableServiceJsonErrorException) {
            return TableUtils.toTableServiceException((TableServiceJsonErrorException)((Object)cause));
        }
        return throwable;
    }

    public static <T> Mono<T> applyOptionalTimeout(Mono<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> Flux<T> applyOptionalTimeout(Flux<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <E extends HttpResponseException> Mono<Response<Void>> swallowExceptionForStatusCode(int statusCode, E httpResponseException, ClientLogger logger) {
        HttpResponse httpResponse = httpResponseException.getResponse();
        if (httpResponse.getStatusCode() == statusCode) {
            return Mono.just((Object)new SimpleResponse(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null));
        }
        return FluxUtil.monoError((ClientLogger)logger, httpResponseException);
    }

    public static Map<String, String[]> parseQueryStringSplitValues(String queryString) {
        return TableUtils.parseQueryStringHelper(queryString, value -> {
            String[] v = value.split(",");
            String[] ret = new String[v.length];
            for (int i = 0; i < v.length; ++i) {
                ret[i] = TableUtils.urlDecode(v[i]);
            }
            return ret;
        });
    }

    private static <T> Map<String, T> parseQueryStringHelper(String queryString, Function<String, T> valueParser) {
        TreeMap<String, T> pieces = new TreeMap<String, T>();
        if (CoreUtils.isNullOrEmpty((CharSequence)queryString)) {
            return pieces;
        }
        for (String kvp : queryString.split("&")) {
            int equalIndex = kvp.indexOf("=");
            String key = TableUtils.urlDecode(kvp.substring(0, equalIndex).toLowerCase(Locale.ROOT));
            T value = valueParser.apply(kvp.substring(equalIndex + 1));
            pieces.putIfAbsent(key, value);
        }
        return pieces;
    }

    public static String urlDecode(String stringToDecode) {
        if (CoreUtils.isNullOrEmpty((CharSequence)stringToDecode)) {
            return "";
        }
        if (stringToDecode.contains("+")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToDecode.length(); ++m) {
                if (stringToDecode.charAt(m) != '+') continue;
                if (m > startDex) {
                    outBuilder.append(TableUtils.decode(stringToDecode.substring(startDex, m)));
                }
                outBuilder.append("+");
                startDex = m + 1;
            }
            if (startDex != stringToDecode.length()) {
                outBuilder.append(TableUtils.decode(stringToDecode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return TableUtils.decode(stringToDecode);
    }

    private static String decode(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlEncode(String stringToEncode) {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.isEmpty()) {
            return "";
        }
        if (stringToEncode.contains(" ")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToEncode.length(); ++m) {
                if (stringToEncode.charAt(m) != ' ') continue;
                if (m > startDex) {
                    outBuilder.append(TableUtils.encode(stringToEncode.substring(startDex, m)));
                }
                outBuilder.append("%20");
                startDex = m + 1;
            }
            if (startDex != stringToEncode.length()) {
                outBuilder.append(TableUtils.encode(stringToEncode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return TableUtils.encode(stringToEncode);
    }

    private static String encode(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String escapeSingleQuotes(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("'", "''");
    }

    public static Exception interpretException(Exception ex) {
        Throwable cause;
        Throwable exception = ex;
        if (exception instanceof ExecutionException) {
            exception = exception.getCause();
        }
        if ((cause = exception.getCause()) instanceof TableTransactionFailedException) {
            return (TableTransactionFailedException)((Object)cause);
        }
        return (Exception)TableUtils.mapThrowableToTableServiceException(exception);
    }

    public static String[] getKeysFromToken(String token) {
        String[] split = token.split(DELIMITER_CONTINUATION_TOKEN, 2);
        String[] keys = new String[2];
        if (split.length == 0) {
            throw new RuntimeException("Split done incorrectly, must have partition key. Token: " + token);
        }
        if (split.length == 2) {
            keys[0] = split[0];
            keys[1] = split[1];
        } else {
            keys[0] = split[0];
            keys[1] = null;
        }
        return keys;
    }

    public static <T> Response<T> callWithOptionalTimeout(Supplier<Response<T>> callable, Duration timeout, ClientLogger logger) {
        return TableUtils.callWithOptionalTimeout(callable, timeout, logger, false);
    }

    public static <T> Response<T> callWithOptionalTimeout(Supplier<Response<T>> callable, Duration timeout, ClientLogger logger, boolean skip409Logging) {
        try {
            return TableUtils.callHandler(callable, timeout, logger);
        }
        catch (Exception thrown) {
            Throwable exception = TableUtils.mapThrowableToTableServiceException(thrown);
            if (exception instanceof TableServiceException) {
                TableServiceException e = (TableServiceException)((Object)exception);
                if (skip409Logging && e.getResponse() != null && e.getResponse().getStatusCode() == 409) {
                    HttpResponse resp = ((TableServiceException)((Object)exception)).getResponse();
                    return new SimpleResponse(resp.getRequest(), resp.getStatusCode(), resp.getHeaders(), null);
                }
            }
            throw logger.logExceptionAsError((RuntimeException)exception);
        }
    }

    public static <T> PagedIterable<T> callIterableWithOptionalTimeout(Supplier<PagedIterable<T>> callable, Duration timeout, ClientLogger logger) {
        try {
            return TableUtils.callHandler(callable, timeout, logger);
        }
        catch (Exception thrown) {
            Throwable exception = TableUtils.mapThrowableToTableServiceException(thrown);
            throw logger.logExceptionAsError((RuntimeException)exception);
        }
    }

    public static <T> T requestWithOptionalTimeout(Supplier<T> request, Duration timeout) throws ExecutionException, InterruptedException, TimeoutException {
        return (T)(TableUtils.hasTimeout(timeout) ? CoreUtils.getResultWithTimeout((Future)SharedExecutorService.getInstance().submit(request::get), (Duration)timeout) : request.get());
    }

    private static boolean hasTimeout(Duration timeout) {
        return timeout != null && (timeout.getSeconds() | (long)timeout.getNano()) > 0L;
    }

    private static <T> T callHandler(Supplier<T> callable, Duration timeout, ClientLogger logger) throws Exception {
        try {
            return (T)(TableUtils.hasTimeout(timeout) ? CoreUtils.getResultWithTimeout((Future)SharedExecutorService.getInstance().submit(callable::get), (Duration)timeout) : callable.get());
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            if (ex instanceof ExecutionException) {
                Throwable cause = ex.getCause();
                throw (Exception)TableUtils.mapThrowableToTableServiceException(cause);
            }
            throw logger.logExceptionAsError(new RuntimeException(ex));
        }
    }

    public static boolean isCosmosEndpoint(String endpoint) {
        try {
            URI endpointUrl = new URI(endpoint);
            String host = endpointUrl.getHost();
            return host.contains(".cosmos.") || host.contains(".cosmosdb.");
        }
        catch (Exception e) {
            return false;
        }
    }
}

