/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.data.appconfiguration.models.ConfigurationSettingsFilter;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.data.appconfiguration.models.SnapshotComposition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ConfigurationSnapshot
implements JsonSerializable<ConfigurationSnapshot> {
    private String name;
    private ConfigurationSnapshotStatus status;
    private final List<ConfigurationSettingsFilter> filters;
    private SnapshotComposition snapshotComposition;
    private OffsetDateTime createdAt;
    private OffsetDateTime expiresAt;
    private Long retentionPeriod;
    private Long sizeInBytes;
    private Long itemCount;
    private Map<String, String> tags;
    private String eTag;

    public ConfigurationSnapshot(List<ConfigurationSettingsFilter> filters) {
        this.filters = filters;
    }

    public String getName() {
        return this.name;
    }

    public ConfigurationSnapshotStatus getStatus() {
        return this.status;
    }

    public List<ConfigurationSettingsFilter> getFilters() {
        return this.filters;
    }

    public SnapshotComposition getSnapshotComposition() {
        return this.snapshotComposition;
    }

    public ConfigurationSnapshot setSnapshotComposition(SnapshotComposition snapshotComposition) {
        this.snapshotComposition = snapshotComposition;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public Duration getRetentionPeriod() {
        if (this.retentionPeriod == null) {
            return null;
        }
        return Duration.ofSeconds(this.retentionPeriod);
    }

    public ConfigurationSnapshot setRetentionPeriod(Duration retentionPeriod) {
        this.retentionPeriod = retentionPeriod == null ? null : Long.valueOf(retentionPeriod.getSeconds());
        return this;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ConfigurationSnapshot setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("composition_type", this.snapshotComposition == null ? null : this.snapshotComposition.toString());
        jsonWriter.writeNumberField("retention_period", (Number)this.retentionPeriod);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationSnapshot fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationSnapshot)jsonReader.readObject(reader -> {
            boolean filtersFound = false;
            List filters = null;
            String name = null;
            ConfigurationSnapshotStatus status = null;
            SnapshotComposition snapshotComposition = null;
            OffsetDateTime createdAt = null;
            OffsetDateTime expiresAt = null;
            Long retentionPeriod = null;
            Long sizeInBytes = null;
            Long itemCount = null;
            Map tags = null;
            String eTag = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filters".equals(fieldName)) {
                    filters = reader.readArray(reader1 -> ConfigurationSettingsFilter.fromJson(reader1));
                    filtersFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ConfigurationSnapshotStatus.fromString(reader.getString());
                    continue;
                }
                if ("composition_type".equals(fieldName)) {
                    snapshotComposition = SnapshotComposition.fromString(reader.getString());
                    continue;
                }
                if ("created".equals(fieldName)) {
                    createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("expires".equals(fieldName)) {
                    expiresAt = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("retention_period".equals(fieldName)) {
                    retentionPeriod = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("size".equals(fieldName)) {
                    sizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("items_count".equals(fieldName)) {
                    itemCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    eTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (filtersFound) {
                ConfigurationSnapshot deserializedConfigurationSnapshot = new ConfigurationSnapshot(filters);
                deserializedConfigurationSnapshot.name = name;
                deserializedConfigurationSnapshot.status = status;
                deserializedConfigurationSnapshot.snapshotComposition = snapshotComposition;
                deserializedConfigurationSnapshot.createdAt = createdAt;
                deserializedConfigurationSnapshot.expiresAt = expiresAt;
                deserializedConfigurationSnapshot.retentionPeriod = retentionPeriod;
                deserializedConfigurationSnapshot.sizeInBytes = sizeInBytes;
                deserializedConfigurationSnapshot.itemCount = itemCount;
                deserializedConfigurationSnapshot.tags = tags;
                deserializedConfigurationSnapshot.eTag = eTag;
                return deserializedConfigurationSnapshot;
            }
            throw new IllegalStateException("Missing required property: filters");
        });
    }
}

