// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * The details of an error.
 */
@Fluent
public final class ErrorDetail implements JsonSerializable<ErrorDetail> {
    /*
     * One of a server-defined set of error codes.
     */
    private final String code;

    /*
     * A human-readable representation of the error.
     */
    private final String message;

    /*
     * An array of details about specific errors that led to this reported error.
     */
    private List<ErrorDetail> details;

    /*
     * An object containing more specific information than the current object about the error.
     */
    private InnerError innererror;

    /**
     * Creates an instance of ErrorDetail class.
     * 
     * @param code the code value to set.
     * @param message the message value to set.
     */
    public ErrorDetail(String code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * Get the code property: One of a server-defined set of error codes.
     * 
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable representation of the error.
     * 
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the details property: An array of details about specific errors that led to this reported error.
     * 
     * @return the details value.
     */
    public List<ErrorDetail> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: An array of details about specific errors that led to this reported error.
     * 
     * @param details the details value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setDetails(List<ErrorDetail> details) {
        this.details = details;
        return this;
    }

    /**
     * Get the innererror property: An object containing more specific information than the current object about the
     * error.
     * 
     * @return the innererror value.
     */
    public InnerError getInnererror() {
        return this.innererror;
    }

    /**
     * Set the innererror property: An object containing more specific information than the current object about the
     * error.
     * 
     * @param innererror the innererror value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setInnererror(InnerError innererror) {
        this.innererror = innererror;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("innererror", this.innererror);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ErrorDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ErrorDetail if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ErrorDetail.
     */
    public static ErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean codeFound = false;
            String code = null;
            boolean messageFound = false;
            String message = null;
            List<ErrorDetail> details = null;
            InnerError innererror = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                } else if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                } else if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ErrorDetail.fromJson(reader1));
                } else if ("innererror".equals(fieldName)) {
                    innererror = InnerError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (codeFound && messageFound) {
                ErrorDetail deserializedErrorDetail = new ErrorDetail(code, message);
                deserializedErrorDetail.details = details;
                deserializedErrorDetail.innererror = innererror;

                return deserializedErrorDetail;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!codeFound) {
                missingProperties.add("code");
            }
            if (!messageFound) {
                missingProperties.add("message");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
