/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr.util;

import com.asprise.ocr.util.StringUtils;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;

public class Utils {
    static String osName = System.getProperty("os.name");
    static String osArch = System.getProperty("os.arch");
    static File dirTempWritable = null;
    static int isLaptop = Integer.MIN_VALUE;

    public static boolean isWindows() {
        return osName != null && osName.toLowerCase().startsWith("windows");
    }

    public static boolean isMac() {
        return osName != null && osName.toLowerCase().startsWith("mac");
    }

    public static boolean is64Bit() {
        return osArch.contains("64");
    }

    public static boolean is32Bit() {
        return !Utils.is64Bit();
    }

    public static String flagToString(long value, Object ... flagValueAndNames) {
        boolean exhausted;
        int i;
        if (flagValueAndNames.length % 2 != 0) {
            throw new IllegalArgumentException("Flag values and names must come in pair");
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < flagValueAndNames.length; i += 2) {
            if ((value & (Long)flagValueAndNames[i]) == 0L) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(flagValueAndNames[i + 1]);
        }
        for (i = 0; i < flagValueAndNames.length; i += 2) {
            if ((value & (Long)flagValueAndNames[i]) == 0L) continue;
            value -= ((Long)flagValueAndNames[i]).longValue();
        }
        boolean bl = exhausted = value == 0L;
        if (!exhausted) {
            sb.append(" (0x").append(Long.toHexString(value)).append(")");
        }
        return sb.toString();
    }

    public static long clearFlags(long value, long ... flags) {
        for (int i = 0; i < flags.length; ++i) {
            if ((value & flags[i]) == 0L) continue;
            value -= flags[i];
        }
        return value;
    }

    public static String getEnvInfo(boolean withClassPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("OS: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch")).append("\n");
        if (!Utils.isWindows()) {
            String uname = null;
            try {
                uname = Utils.execute(true, false, false, new String[]{"/usr/bin/uname", "-a"}, null, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (StringUtils.isEmpty(uname)) {
                try {
                    uname = Utils.execute(true, false, false, new String[]{"/bin/uname", "-a"}, null, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty(uname)) {
                sb.append(uname).append("\n");
            }
        }
        sb.append("JVM: ").append(Utils.firstNotNull(System.getProperty("java.runtime.version"), System.getProperty("java.version"))).append(" ").append(Utils.is64Bit() ? "64bit" : "32bit").append(" by ").append(System.getProperty("java.vendor")).append("\n");
        if (withClassPath) {
            sb.append("Classpath: ").append(System.getProperty("java.class.path"));
        }
        return sb.toString();
    }

    public static String getRunInfo() {
        StringBuilder sb = new StringBuilder();
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Object[] threads = threadSet.toArray(new Thread[threadSet.size()]);
        sb.append("Threads: [").append(threads.length).append("] ").append(Arrays.toString(threads));
        return sb.toString();
    }

    public static Object firstNotNull(Object ... args) {
        for (Object o : args) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public static String firstNotEmpty(String ... args) {
        for (String s : args) {
            if (s == null || s.trim().length() <= 0) continue;
            return s;
        }
        return null;
    }

    public static void displayErrorDialogAndThrowException(String errorMesg, Throwable t, boolean rethrowException) {
        try {
            if (errorMesg != null && errorMesg.length() > 80) {
                errorMesg = errorMesg.replaceAll("(.{80})", "$1\n");
            }
            JOptionPane.showMessageDialog(null, errorMesg, "Fatal error", 0);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        if (rethrowException) {
            throw new RuntimeException(errorMesg, t);
        }
    }

    public static boolean testCreateFileInside(File folder) {
        if (!folder.exists()) {
            try {
                folder.mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!folder.isDirectory()) {
            return false;
        }
        File f = new File(folder, "t-" + System.currentTimeMillis() + "-" + StringUtils.randomAlphanumeric(3));
        try {
            boolean fileCreated = f.createNewFile();
            boolean fileDeleted = f.delete();
            return fileCreated;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static File getTempFolderWritable() {
        File[] dirs;
        if (dirTempWritable != null) {
            return dirTempWritable;
        }
        for (File dir : dirs = new File[]{new File(System.getProperty("java.io.tmpdir")), new File(System.getProperty("user.dir")), new File(Utils.isWindows() ? (System.getProperty("java.io.tmpdir") != null && System.getProperty("java.io.tmpdir").length() > 0 ? System.getProperty("java.io.tmpdir").substring(0, 1) : "C") + ":\\" : "/")}) {
            if (!Utils.testCreateFileInside(dir)) continue;
            dirTempWritable = dir;
            return dirTempWritable;
        }
        StringBuilder errorMesg = new StringBuilder("Failed to find a writable temp directory. Tried: ");
        for (int i = 0; i < dirs.length; ++i) {
            errorMesg.append(i == 0 ? "" : ", ");
            errorMesg.append(dirs[i].getAbsolutePath());
        }
        Utils.displayErrorDialogAndThrowException(errorMesg.toString(), null, true);
        return null;
    }

    public static void unzipToFolder(File zipFile, File outputFolder) throws IOException {
        outputFolder.mkdirs();
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry ze = zis.getNextEntry();
        byte[] buffer = new byte[4096];
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(outputFolder + File.separator + fileName);
            if (ze.isDirectory()) {
                newFile.mkdirs();
            } else {
                int len;
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractResourceToFolder(ClassLoader classLoader, String resourcePath, File targetFolder, boolean forceWrite) throws IOException {
        int lastSlashPos = Math.max(resourcePath.lastIndexOf(47), resourcePath.lastIndexOf(92));
        String simpleName = lastSlashPos > 0 ? resourcePath.substring(lastSlashPos + 1) : resourcePath;
        targetFolder.mkdirs();
        if (!targetFolder.exists()) {
            throw new IOException("Folder does not exist despite effort of attempting to create it: " + targetFolder.getAbsolutePath());
        }
        File targetFile = new File(targetFolder, simpleName);
        boolean skipWriting = false;
        try {
            if (!forceWrite && targetFile.exists()) {
                String md5ExistingFile = Utils.getMd5(new FileInputStream(targetFile));
                String md5Stream = Utils.getMd5(classLoader.getResourceAsStream(resourcePath));
                if (md5ExistingFile != null && md5Stream != null && md5ExistingFile.equalsIgnoreCase(md5Stream)) {
                    skipWriting = true;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!skipWriting) {
            InputStream inputStream = classLoader.getResourceAsStream(resourcePath);
            if (inputStream == null) {
                throw new IOException("Can not find resource: " + resourcePath);
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(targetFile);
                byte[] buffer = new byte[4096];
                int bytesRead = 0;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
            }
            finally {
                inputStream.close();
            }
        }
        if (resourcePath.endsWith(".zip")) {
            String simpleNameWithoutExt = targetFile.getName().substring(0, targetFile.getName().lastIndexOf("."));
            File zipOutputFolder = new File(targetFile.getAbsoluteFile().getParentFile(), simpleNameWithoutExt);
            if (zipOutputFolder.exists() && zipOutputFolder.isFile()) {
                zipOutputFolder.delete();
                zipOutputFolder = new File(zipOutputFolder.getAbsolutePath());
                zipOutputFolder.mkdirs();
            }
            Utils.unzipToFolder(targetFile, zipOutputFolder);
            return zipOutputFolder;
        }
        return targetFile;
    }

    static String getMd5(InputStream input) {
        if (input == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream dis = new DigestInputStream(input, md);
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
            dis.close();
            byte[] raw = md.digest();
            BigInteger bigInt = new BigInteger(1, raw);
            StringBuilder hash = new StringBuilder(bigInt.toString(16));
            while (hash.length() < 32) {
                hash.insert(0, '0');
            }
            return hash.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getFileExtensionWithoutDot(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public static boolean openInFileExplorer(String path) {
        if (Utils.isWindows()) {
            try {
                Process p = new ProcessBuilder("explorer.exe", path).start();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Utils.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }

    public static void saveToFile(URL url, File target) throws IOException {
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        FileOutputStream output = new FileOutputStream(target);
        output.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
    }

    public static int isLaptop() {
        if (isLaptop != Integer.MIN_VALUE) {
            return isLaptop;
        }
        if (!Utils.isWindows()) {
            return -1;
        }
        String result = "";
        File file = null;
        try {
            String line;
            file = File.createTempFile("info", ".vbs", null);
            FileWriter fw = new FileWriter(file);
            String vbs = "strComputer = \".\"\nSet objWMIService = GetObject(\"winmgmts:\" _\n    & \"{impersonationLevel=impersonate}!\\\\\" & strComputer & \"\\root\\cimv2\")\nSet colChassis = objWMIService.ExecQuery _\n    (\"Select * from Win32_SystemEnclosure\")\nFor Each objChassis in colChassis\n    For  Each strChassisType in objChassis.ChassisTypes\n        Wscript.Echo strChassisType\n    Next\nNext\n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo \"" + file.getPath() + "\"");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (IOException e) {
            return -1;
        }
        try {
            file.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        int chassis = Integer.parseInt(result.trim());
        return chassis >= 8 && chassis <= 12 ? 1 : 0;
    }

    public static void main(String[] args) {
        System.out.println(Utils.execute(true, true, true, new String[]{"cmd", "/c", "dir"}, new File("W:"), null));
    }

    public static String execute(boolean returnOutput, boolean returnError, boolean throwException, String[] cmd, File dir, String[] env) {
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        try {
            Process proc = Runtime.getRuntime().exec(cmd, env, dir);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String line = null;
            while ((line = stdInput.readLine()) != null) {
                if (output.length() > 0) {
                    output.append("\n");
                }
                output.append(line);
            }
            while ((line = stdError.readLine()) != null) {
                if (error.length() > 0) {
                    error.append("\n");
                }
                error.append(line);
            }
            if (returnOutput) {
                return output.toString();
            }
            if (returnError) {
                return error.toString();
            }
            return null;
        }
        catch (Throwable t) {
            if (throwException) {
                throw new RuntimeException(t);
            }
            if (System.getProperty("DEBUG") != null) {
                t.printStackTrace();
            }
            if (returnOutput) {
                return output.length() > 0 ? output.toString() : null;
            }
            if (returnError) {
                return error.length() > 0 ? error.toString() : t.getMessage();
            }
            return null;
        }
    }
}

