/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

public class SourceSearcher {
    @NonNull
    private final List<File> mSourceFolders;
    private final String[] mExtensions;
    @Nullable
    private WaitableExecutor<Void> mExecutor;

    public SourceSearcher(@NonNull List<File> sourceFolders, String ... extensions) {
        this.mSourceFolders = sourceFolders;
        this.mExtensions = extensions;
    }

    public void setUseExecutor(boolean useExecutor) {
        this.mExecutor = useExecutor ? new WaitableExecutor() : null;
    }

    public void search(@NonNull SourceFileProcessor processor) throws ProcessException, LoggedErrorException, InterruptedException, IOException {
        for (File file : this.mSourceFolders) {
            this.processFile(file, file, processor);
        }
        if (this.mExecutor != null) {
            this.mExecutor.waitForTasksWithQuickFail(true);
        }
    }

    private void processFile(final @NonNull File rootFolder, final @NonNull File file, final @NonNull SourceFileProcessor processor) throws ProcessException, IOException {
        File[] children;
        if (file.isFile()) {
            if (this.checkExtension(file)) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            processor.processFile(rootFolder, file);
                            return null;
                        }
                    });
                } else {
                    processor.processFile(rootFolder, file);
                }
            }
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.processFile(rootFolder, child, processor);
            }
        }
    }

    private boolean checkExtension(File file) {
        if (this.mExtensions.length == 0) {
            return true;
        }
        String filename = file.getName();
        int pos = filename.indexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1);
            for (String ext : this.mExtensions) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface SourceFileProcessor {
        public void processFile(@NonNull File var1, @NonNull File var2) throws ProcessException, IOException;
    }
}

