/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.BuildType;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Objects;

public class DefaultBuildType
extends BaseConfigImpl
implements BuildType {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private boolean mDebuggable = false;
    private boolean mPseudoLocalesEnabled = false;
    private boolean mTestCoverageEnabled = false;
    private boolean mJniDebuggable = false;
    private boolean mRenderscriptDebuggable = false;
    private int mRenderscriptOptimLevel = 3;
    private String mApplicationIdSuffix = null;
    private String mVersionNameSuffix = null;
    private boolean mMinifyEnabled = false;
    private SigningConfig mSigningConfig = null;
    private boolean mEmbedMicroApp = true;
    private boolean mZipAlignEnabled = true;

    public DefaultBuildType(@NonNull String name) {
        this.mName = name;
    }

    public DefaultBuildType initWith(DefaultBuildType that) {
        this._initWith(that);
        this.setDebuggable(that.isDebuggable());
        this.setTestCoverageEnabled(that.isTestCoverageEnabled());
        this.setJniDebuggable(that.isJniDebuggable());
        this.setRenderscriptDebuggable(that.isRenderscriptDebuggable());
        this.setRenderscriptOptimLevel(that.getRenderscriptOptimLevel());
        this.setApplicationIdSuffix(that.getApplicationIdSuffix());
        this.setVersionNameSuffix(that.getVersionNameSuffix());
        this.setMinifyEnabled(that.isMinifyEnabled());
        this.setZipAlignEnabled(that.isZipAlignEnabled());
        this.setSigningConfig(that.getSigningConfig());
        this.setEmbedMicroApp(that.isEmbedMicroApp());
        this.setPseudoLocalesEnabled(that.isPseudoLocalesEnabled());
        return this;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public BuildType setDebuggable(boolean debuggable) {
        this.mDebuggable = debuggable;
        return this;
    }

    public boolean isDebuggable() {
        return this.mDebuggable || this.mTestCoverageEnabled;
    }

    public void setTestCoverageEnabled(boolean testCoverageEnabled) {
        this.mTestCoverageEnabled = testCoverageEnabled;
    }

    public boolean isTestCoverageEnabled() {
        return this.mTestCoverageEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.mPseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    public boolean isPseudoLocalesEnabled() {
        return this.mPseudoLocalesEnabled;
    }

    @NonNull
    public BuildType setJniDebuggable(boolean jniDebugBuild) {
        this.mJniDebuggable = jniDebugBuild;
        return this;
    }

    public boolean isJniDebuggable() {
        return this.mJniDebuggable;
    }

    public boolean isRenderscriptDebuggable() {
        return this.mRenderscriptDebuggable;
    }

    public BuildType setRenderscriptDebuggable(boolean renderscriptDebugBuild) {
        this.mRenderscriptDebuggable = renderscriptDebugBuild;
        return this;
    }

    public int getRenderscriptOptimLevel() {
        return this.mRenderscriptOptimLevel;
    }

    public void setRenderscriptOptimLevel(int renderscriptOptimLevel) {
        this.mRenderscriptOptimLevel = renderscriptOptimLevel;
    }

    @NonNull
    public BuildType setApplicationIdSuffix(@Nullable String applicationIdSuffix) {
        this.mApplicationIdSuffix = applicationIdSuffix;
        return this;
    }

    @Nullable
    public String getApplicationIdSuffix() {
        return this.mApplicationIdSuffix;
    }

    @NonNull
    public BuildType setVersionNameSuffix(@Nullable String versionNameSuffix) {
        this.mVersionNameSuffix = versionNameSuffix;
        return this;
    }

    @Nullable
    public String getVersionNameSuffix() {
        return this.mVersionNameSuffix;
    }

    @NonNull
    public BuildType setMinifyEnabled(boolean enabled) {
        this.mMinifyEnabled = enabled;
        return this;
    }

    public boolean isMinifyEnabled() {
        return this.mMinifyEnabled;
    }

    @NonNull
    public BuildType setZipAlignEnabled(boolean zipAlign) {
        this.mZipAlignEnabled = zipAlign;
        return this;
    }

    public boolean isZipAlignEnabled() {
        return this.mZipAlignEnabled;
    }

    @NonNull
    public BuildType setSigningConfig(@Nullable SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    public boolean isEmbedMicroApp() {
        return this.mEmbedMicroApp;
    }

    public void setEmbedMicroApp(boolean embedMicroApp) {
        this.mEmbedMicroApp = embedMicroApp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultBuildType buildType = (DefaultBuildType)o;
        if (!this.mName.equals(buildType.mName)) {
            return false;
        }
        if (this.mDebuggable != buildType.mDebuggable) {
            return false;
        }
        if (this.mTestCoverageEnabled != buildType.mTestCoverageEnabled) {
            return false;
        }
        if (this.mJniDebuggable != buildType.mJniDebuggable) {
            return false;
        }
        if (this.mPseudoLocalesEnabled != buildType.mPseudoLocalesEnabled) {
            return false;
        }
        if (this.mRenderscriptDebuggable != buildType.mRenderscriptDebuggable) {
            return false;
        }
        if (this.mRenderscriptOptimLevel != buildType.mRenderscriptOptimLevel) {
            return false;
        }
        if (this.mMinifyEnabled != buildType.mMinifyEnabled) {
            return false;
        }
        if (this.mZipAlignEnabled != buildType.mZipAlignEnabled) {
            return false;
        }
        if (this.mApplicationIdSuffix != null ? !this.mApplicationIdSuffix.equals(buildType.mApplicationIdSuffix) : buildType.mApplicationIdSuffix != null) {
            return false;
        }
        if (this.mVersionNameSuffix != null ? !this.mVersionNameSuffix.equals(buildType.mVersionNameSuffix) : buildType.mVersionNameSuffix != null) {
            return false;
        }
        if (this.mSigningConfig != null ? !this.mSigningConfig.equals(buildType.mSigningConfig) : buildType.mSigningConfig != null) {
            return false;
        }
        return this.mEmbedMicroApp == buildType.mEmbedMicroApp;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + (this.mDebuggable ? 1 : 0);
        result = 31 * result + (this.mTestCoverageEnabled ? 1 : 0);
        result = 31 * result + (this.mJniDebuggable ? 1 : 0);
        result = 31 * result + (this.mPseudoLocalesEnabled ? 1 : 0);
        result = 31 * result + (this.mRenderscriptDebuggable ? 1 : 0);
        result = 31 * result + this.mRenderscriptOptimLevel;
        result = 31 * result + (this.mApplicationIdSuffix != null ? this.mApplicationIdSuffix.hashCode() : 0);
        result = 31 * result + (this.mVersionNameSuffix != null ? this.mVersionNameSuffix.hashCode() : 0);
        result = 31 * result + (this.mMinifyEnabled ? 1 : 0);
        result = 31 * result + (this.mZipAlignEnabled ? 1 : 0);
        result = 31 * result + (this.mSigningConfig != null ? this.mSigningConfig.hashCode() : 0);
        result = 31 * result + (this.mEmbedMicroApp ? 1 : 0);
        return result;
    }

    @Override
    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("debuggable", this.mDebuggable).add("testCoverageEnabled", this.mTestCoverageEnabled).add("jniDebuggable", this.mJniDebuggable).add("pseudoLocalesEnabled", this.mPseudoLocalesEnabled).add("renderscriptDebuggable", this.mRenderscriptDebuggable).add("renderscriptOptimLevel", this.mRenderscriptOptimLevel).add("applicationIdSuffix", (Object)this.mApplicationIdSuffix).add("versionNameSuffix", (Object)this.mVersionNameSuffix).add("minifyEnabled", this.mMinifyEnabled).add("zipAlignEnabled", this.mZipAlignEnabled).add("signingConfig", (Object)this.mSigningConfig).add("embedMicroApp", this.mEmbedMicroApp).add("mBuildConfigFields", this.getBuildConfigFields()).add("mResValues", this.getResValues()).add("mProguardFiles", (Object)this.getProguardFiles()).add("mConsumerProguardFiles", (Object)this.getConsumerProguardFiles()).add("mManifestPlaceholders", this.getManifestPlaceholders()).toString();
    }
}

