/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.ide.common.internal.CommandLineRunner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AidlProcessor
implements SourceSearcher.SourceFileProcessor {
    @NonNull
    private final String mAidlExecutable;
    @NonNull
    private final String mFrameworkLocation;
    @NonNull
    private final List<File> mImportFolders;
    @NonNull
    private final File mSourceOutputDir;
    @NonNull
    private final DependencyFileProcessor mDependencyFileProcessor;
    @NonNull
    private final CommandLineRunner mRunner;

    public AidlProcessor(@NonNull String aidlExecutable, @NonNull String frameworkLocation, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull DependencyFileProcessor dependencyFileProcessor, @NonNull CommandLineRunner runner) {
        this.mAidlExecutable = aidlExecutable;
        this.mFrameworkLocation = frameworkLocation;
        this.mImportFolders = importFolders;
        this.mSourceOutputDir = sourceOutputDir;
        this.mDependencyFileProcessor = dependencyFileProcessor;
        this.mRunner = runner;
    }

    @Override
    public void processFile(File sourceFile) throws IOException, InterruptedException {
        ArrayList command = Lists.newArrayList();
        command.add(this.mAidlExecutable);
        command.add("-p" + this.mFrameworkLocation);
        command.add("-o" + this.mSourceOutputDir.getAbsolutePath());
        for (File f : this.mImportFolders) {
            command.add("-I" + f.getAbsolutePath());
        }
        File depFile = File.createTempFile("aidl", ".d");
        command.add("-d" + depFile.getAbsolutePath());
        command.add(sourceFile.getAbsolutePath());
        this.mRunner.runCmdLine((List)command);
        if (this.mDependencyFileProcessor.processFile(depFile)) {
            depFile.delete();
        }
    }
}

