/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.builder.png.Chunk;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LayoutBoundChunkBuilder {
    private static final byte[] sChunkType = new byte[]{110, 112, 76, 98};
    private final int mLeft;
    private final int mTop;
    private final int mRight;
    private final int mBottom;

    LayoutBoundChunkBuilder(int left, int top, int right, int bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
    }

    @NonNull
    Chunk getChunk() {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.mLeft);
        buffer.putInt(this.mTop);
        buffer.putInt(this.mRight);
        buffer.putInt(this.mBottom);
        return new Chunk(sChunkType, buffer.array());
    }
}

