/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.GuardedBy;
import com.android.annotations.concurrency.Immutable;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreDexCache {
    private static final String NODE_ITEMS = "pre-dex-items";
    private static final String NODE_ITEM = "item";
    private static final String ATTR_JUMBO_MODE = "jumboMode";
    private static final String ATTR_REVISION = "revision";
    private static final String ATTR_JAR = "jar";
    private static final String ATTR_DEX = "dex";
    private static final String ATTR_SHA1 = "sha1";
    private static final PreDexCache sSingleton = new PreDexCache();
    @GuardedBy(value="this")
    private boolean mLoaded = false;
    @GuardedBy(value="this")
    private final Map<Key, Item> mMap = Maps.newHashMap();
    @GuardedBy(value="this")
    private final Map<Key, StoredItem> mStoredItems = Maps.newHashMap();
    @GuardedBy(value="this")
    private int mMisses = 0;
    @GuardedBy(value="this")
    private int mHits = 0;

    public static PreDexCache getCache() {
        return sSingleton;
    }

    public synchronized void load(@NonNull File itemStorage) {
        if (this.mLoaded) {
            return;
        }
        this.loadItems(itemStorage);
        this.mLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDexLibrary(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions, @NonNull BuildToolInfo buildToolInfo, boolean verbose, @NonNull CommandLineRunner commandLineRunner) throws IOException, LoggedErrorException, InterruptedException {
        block15: {
            Pair<Item, Boolean> pair = this.getItem(inputFile, outFile, buildToolInfo, dexOptions);
            if (((Boolean)pair.getSecond()).booleanValue()) {
                try {
                    AndroidBuilder.preDexLibrary(inputFile, outFile, dexOptions, buildToolInfo, verbose, commandLineRunner);
                    PreDexCache preDexCache = this;
                    synchronized (preDexCache) {
                        ++this.mMisses;
                        break block15;
                    }
                }
                catch (IOException exception) {
                    outFile.delete();
                    throw exception;
                }
                catch (LoggedErrorException exception) {
                    outFile.delete();
                    throw exception;
                }
                catch (InterruptedException exception) {
                    outFile.delete();
                    throw exception;
                }
                finally {
                    ((Item)pair.getFirst()).getLatch().countDown();
                }
            }
            ((Item)pair.getFirst()).getLatch().await();
            File fromFile = ((Item)pair.getFirst()).getOutputFile();
            if (fromFile.isFile()) {
                Files.copy((File)((Item)pair.getFirst()).getOutputFile(), (File)outFile);
                PreDexCache preDexCache = this;
                synchronized (preDexCache) {
                    ++this.mHits;
                }
            }
        }
    }

    synchronized int getMisses() {
        return this.mMisses;
    }

    synchronized int getHits() {
        return this.mHits;
    }

    private synchronized Pair<Item, Boolean> getItem(@NonNull File inputFile, @NonNull File outFile, @NonNull BuildToolInfo buildToolInfo, @NonNull DexOptions dexOptions) throws IOException {
        Key itemKey = Key.of(inputFile, buildToolInfo.getRevision(), dexOptions.getJumboMode());
        Item item = this.mMap.get(itemKey);
        boolean newItem = false;
        if (item == null) {
            File dexFile;
            StoredItem storedItem = this.mStoredItems.get(itemKey);
            if (storedItem != null && (dexFile = storedItem.getOutputFile()).isFile() && storedItem.getSourceHash().equals((Object)Files.hash((File)inputFile, (HashFunction)Hashing.sha1()))) {
                item = new Item(inputFile, dexFile, new CountDownLatch(0));
            }
            if (item == null) {
                item = new Item(inputFile, outFile, new CountDownLatch(1));
                newItem = true;
            }
            this.mMap.put(itemKey, item);
        }
        return Pair.of((Object)item, (Object)newItem);
    }

    public synchronized void clear(@Nullable File itemStorage, @Nullable ILogger logger) throws IOException {
        if (!this.mMap.isEmpty()) {
            if (itemStorage != null) {
                this.saveItems(itemStorage);
            }
            if (logger != null) {
                logger.info("PREDEX CACHE HITS:   " + this.mHits, new Object[0]);
                logger.info("PREDEX CACHE MISSES: " + this.mMisses, new Object[0]);
            }
        }
        this.mMap.clear();
        this.mStoredItems.clear();
        this.mHits = 0;
        this.mMisses = 0;
    }

    private synchronized void loadItems(@NonNull File itemStorage) {
        if (!itemStorage.isFile()) {
            return;
        }
        try {
            Document document = XmlUtils.parseUtfXmlFile((File)itemStorage, (boolean)true);
            Element rootNode = document.getDocumentElement();
            if (rootNode == null || !NODE_ITEMS.equals(rootNode.getLocalName())) {
                return;
            }
            NodeList nodes = rootNode.getChildNodes();
            int n = nodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !NODE_ITEM.equals(node.getLocalName())) continue;
                NamedNodeMap attrMap = node.getAttributes();
                File sourceFile = new File(attrMap.getNamedItem(ATTR_JAR).getNodeValue());
                FullRevision revision = FullRevision.parseRevision((String)attrMap.getNamedItem(ATTR_REVISION).getNodeValue());
                StoredItem item = new StoredItem(sourceFile, new File(attrMap.getNamedItem(ATTR_DEX).getNodeValue()), HashCode.fromString((String)attrMap.getNamedItem(ATTR_SHA1).getNodeValue()));
                Key key = Key.of(sourceFile, revision, Boolean.parseBoolean(attrMap.getNamedItem(ATTR_JUMBO_MODE).getNodeValue()));
                this.mStoredItems.put(key, item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void saveItems(@NonNull File itemStorage) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootNode = document.createElement(NODE_ITEMS);
            document.appendChild(rootNode);
            HashSet keys = Sets.newHashSetWithExpectedSize((int)(this.mMap.size() + this.mStoredItems.size()));
            keys.addAll(this.mMap.keySet());
            keys.addAll(this.mStoredItems.keySet());
            for (Key key : keys) {
                Item item = this.mMap.get(key);
                if (item != null) {
                    Node itemNode = PreDexCache.createItemNode(document, item.getSourceFile(), item.getOutputFile(), key.getBuildToolsRevision(), key.isJumboMode(), Files.hash((File)item.getSourceFile(), (HashFunction)Hashing.sha1()));
                    rootNode.appendChild(itemNode);
                    continue;
                }
                StoredItem storedItem = this.mStoredItems.get(key);
                if (storedItem == null || !storedItem.getSourceFile().isFile() || !storedItem.getOutputFile().isFile()) continue;
                Node itemNode = PreDexCache.createItemNode(document, storedItem.getSourceFile(), storedItem.getOutputFile(), key.getBuildToolsRevision(), key.isJumboMode(), storedItem.getSourceHash());
                rootNode.appendChild(itemNode);
            }
            String content = XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
            itemStorage.getParentFile().mkdirs();
            Files.write((CharSequence)content, (File)itemStorage, (Charset)Charsets.UTF_8);
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
    }

    private static Node createItemNode(@NonNull Document document, @NonNull File sourceFile, @NonNull File outputFile, @NonNull FullRevision toolsRevision, boolean jumboMode, @NonNull HashCode hashCode) {
        Element itemNode = document.createElement(NODE_ITEM);
        Attr attr = document.createAttribute(ATTR_JAR);
        attr.setValue(sourceFile.getPath());
        itemNode.getAttributes().setNamedItem(attr);
        attr = document.createAttribute(ATTR_DEX);
        attr.setValue(outputFile.getPath());
        itemNode.getAttributes().setNamedItem(attr);
        attr = document.createAttribute(ATTR_REVISION);
        attr.setValue(toolsRevision.toString());
        itemNode.getAttributes().setNamedItem(attr);
        attr = document.createAttribute(ATTR_JUMBO_MODE);
        attr.setValue(Boolean.toString(jumboMode));
        itemNode.getAttributes().setNamedItem(attr);
        attr = document.createAttribute(ATTR_SHA1);
        attr.setValue(hashCode.toString());
        itemNode.getAttributes().setNamedItem(attr);
        return itemNode;
    }

    @Immutable
    private static class Key {
        @NonNull
        private final File mSourceFile;
        @NonNull
        private final FullRevision mBuildToolsRevision;
        private final boolean mJumboMode;

        private static Key of(@NonNull File sourceFile, @NonNull FullRevision buildToolsRevision, boolean jumboMode) {
            return new Key(sourceFile, buildToolsRevision, jumboMode);
        }

        private Key(@NonNull File sourceFile, @NonNull FullRevision buildToolsRevision, boolean jumboMode) {
            this.mSourceFile = sourceFile;
            this.mBuildToolsRevision = buildToolsRevision;
            this.mJumboMode = jumboMode;
        }

        @NonNull
        private FullRevision getBuildToolsRevision() {
            return this.mBuildToolsRevision;
        }

        public boolean isJumboMode() {
            return this.mJumboMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.mJumboMode != key.mJumboMode) {
                return false;
            }
            if (!this.mBuildToolsRevision.equals((Object)key.mBuildToolsRevision)) {
                return false;
            }
            return this.mSourceFile.equals(key.mSourceFile);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mSourceFile, this.mBuildToolsRevision, this.mJumboMode});
        }
    }

    @Immutable
    private static class StoredItem {
        @NonNull
        private final File mSourceFile;
        @NonNull
        private final File mOutputFile;
        @NonNull
        private final HashCode mSourceHash;

        StoredItem(@NonNull File sourceFile, @NonNull File outputFile, @NonNull HashCode sourceHash) {
            this.mSourceFile = sourceFile;
            this.mOutputFile = outputFile;
            this.mSourceHash = sourceHash;
        }

        @NonNull
        private File getSourceFile() {
            return this.mSourceFile;
        }

        @NonNull
        private File getOutputFile() {
            return this.mOutputFile;
        }

        @NonNull
        private HashCode getSourceHash() {
            return this.mSourceHash;
        }
    }

    @Immutable
    private static class Item {
        @NonNull
        private final File mSourceFile;
        @NonNull
        private final File mOutputFile;
        @NonNull
        private final CountDownLatch mLatch;

        Item(@NonNull File sourceFile, @NonNull File outputFile, @NonNull CountDownLatch latch) {
            this.mSourceFile = sourceFile;
            this.mOutputFile = outputFile;
            this.mLatch = latch;
        }

        @NonNull
        private File getSourceFile() {
            return this.mSourceFile;
        }

        @NonNull
        private File getOutputFile() {
            return this.mOutputFile;
        }

        @NonNull
        private CountDownLatch getLatch() {
            return this.mLatch;
        }
    }
}

