/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.ViewBillingRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ViewBillingRequestMarshaller
implements Marshaller<Request<ViewBillingRequest>, ViewBillingRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ViewBillingRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ViewBillingRequest> marshall(ViewBillingRequest viewBillingRequest) {
        if (viewBillingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)viewBillingRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.ViewBilling");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (viewBillingRequest.getStart() != null) {
                jsonGenerator.writeFieldName("Start").writeValue(viewBillingRequest.getStart());
            }
            if (viewBillingRequest.getEnd() != null) {
                jsonGenerator.writeFieldName("End").writeValue(viewBillingRequest.getEnd());
            }
            if (viewBillingRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(viewBillingRequest.getMarker());
            }
            if (viewBillingRequest.getMaxItems() != null) {
                jsonGenerator.writeFieldName("MaxItems").writeValue(viewBillingRequest.getMaxItems().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

