/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.AlarmIdentifier;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.HealthCheckConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateHealthCheckRequestMarshaller
implements Marshaller<Request<CreateHealthCheckRequest>, CreateHealthCheckRequest> {
    public Request<CreateHealthCheckRequest> marshall(CreateHealthCheckRequest createHealthCheckRequest) {
        if (createHealthCheckRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHealthCheckRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateHealthCheckRequest");
            if (createHealthCheckRequest != null) {
                HealthCheckConfig healthCheckConfig;
                if (createHealthCheckRequest.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(createHealthCheckRequest.getCallerReference()).endElement();
                }
                if ((healthCheckConfig = createHealthCheckRequest.getHealthCheckConfig()) != null) {
                    AlarmIdentifier alarmIdentifier;
                    SdkInternalList healthCheckConfigRegionsList;
                    SdkInternalList healthCheckConfigChildHealthChecksList;
                    xmlWriter.startElement("HealthCheckConfig");
                    if (healthCheckConfig.getIPAddress() != null) {
                        xmlWriter.startElement("IPAddress").value(healthCheckConfig.getIPAddress()).endElement();
                    }
                    if (healthCheckConfig.getPort() != null) {
                        xmlWriter.startElement("Port").value((Object)healthCheckConfig.getPort()).endElement();
                    }
                    if (healthCheckConfig.getType() != null) {
                        xmlWriter.startElement("Type").value(healthCheckConfig.getType()).endElement();
                    }
                    if (healthCheckConfig.getResourcePath() != null) {
                        xmlWriter.startElement("ResourcePath").value(healthCheckConfig.getResourcePath()).endElement();
                    }
                    if (healthCheckConfig.getFullyQualifiedDomainName() != null) {
                        xmlWriter.startElement("FullyQualifiedDomainName").value(healthCheckConfig.getFullyQualifiedDomainName()).endElement();
                    }
                    if (healthCheckConfig.getSearchString() != null) {
                        xmlWriter.startElement("SearchString").value(healthCheckConfig.getSearchString()).endElement();
                    }
                    if (healthCheckConfig.getRequestInterval() != null) {
                        xmlWriter.startElement("RequestInterval").value((Object)healthCheckConfig.getRequestInterval()).endElement();
                    }
                    if (healthCheckConfig.getFailureThreshold() != null) {
                        xmlWriter.startElement("FailureThreshold").value((Object)healthCheckConfig.getFailureThreshold()).endElement();
                    }
                    if (healthCheckConfig.getMeasureLatency() != null) {
                        xmlWriter.startElement("MeasureLatency").value((Object)healthCheckConfig.getMeasureLatency()).endElement();
                    }
                    if (healthCheckConfig.getInverted() != null) {
                        xmlWriter.startElement("Inverted").value((Object)healthCheckConfig.getInverted()).endElement();
                    }
                    if (healthCheckConfig.getHealthThreshold() != null) {
                        xmlWriter.startElement("HealthThreshold").value((Object)healthCheckConfig.getHealthThreshold()).endElement();
                    }
                    if (!(healthCheckConfigChildHealthChecksList = (SdkInternalList)healthCheckConfig.getChildHealthChecks()).isEmpty() || !healthCheckConfigChildHealthChecksList.isAutoConstruct()) {
                        xmlWriter.startElement("ChildHealthChecks");
                        for (Object healthCheckConfigChildHealthChecksListValue : healthCheckConfigChildHealthChecksList) {
                            xmlWriter.startElement("ChildHealthCheck");
                            xmlWriter.value((String)healthCheckConfigChildHealthChecksListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (healthCheckConfig.getEnableSNI() != null) {
                        xmlWriter.startElement("EnableSNI").value((Object)healthCheckConfig.getEnableSNI()).endElement();
                    }
                    if (!(healthCheckConfigRegionsList = (SdkInternalList)healthCheckConfig.getRegions()).isEmpty() || !healthCheckConfigRegionsList.isAutoConstruct()) {
                        xmlWriter.startElement("Regions");
                        for (String healthCheckConfigRegionsListValue : healthCheckConfigRegionsList) {
                            xmlWriter.startElement("Region");
                            xmlWriter.value(healthCheckConfigRegionsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((alarmIdentifier = healthCheckConfig.getAlarmIdentifier()) != null) {
                        xmlWriter.startElement("AlarmIdentifier");
                        if (alarmIdentifier.getRegion() != null) {
                            xmlWriter.startElement("Region").value(alarmIdentifier.getRegion()).endElement();
                        }
                        if (alarmIdentifier.getName() != null) {
                            xmlWriter.startElement("Name").value(alarmIdentifier.getName()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (healthCheckConfig.getInsufficientDataHealthStatus() != null) {
                        xmlWriter.startElement("InsufficientDataHealthStatus").value(healthCheckConfig.getInsufficientDataHealthStatus()).endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

