/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The visual publish options of a visual in a dashboard
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DashboardVisualPublishOptions"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DashboardVisualPublishOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Determines if hidden fields are included in an exported dashboard.
     * </p>
     */
    private ExportHiddenFieldsOption exportHiddenFieldsOption;

    /**
     * <p>
     * Determines if hidden fields are included in an exported dashboard.
     * </p>
     * 
     * @param exportHiddenFieldsOption
     *        Determines if hidden fields are included in an exported dashboard.
     */

    public void setExportHiddenFieldsOption(ExportHiddenFieldsOption exportHiddenFieldsOption) {
        this.exportHiddenFieldsOption = exportHiddenFieldsOption;
    }

    /**
     * <p>
     * Determines if hidden fields are included in an exported dashboard.
     * </p>
     * 
     * @return Determines if hidden fields are included in an exported dashboard.
     */

    public ExportHiddenFieldsOption getExportHiddenFieldsOption() {
        return this.exportHiddenFieldsOption;
    }

    /**
     * <p>
     * Determines if hidden fields are included in an exported dashboard.
     * </p>
     * 
     * @param exportHiddenFieldsOption
     *        Determines if hidden fields are included in an exported dashboard.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DashboardVisualPublishOptions withExportHiddenFieldsOption(ExportHiddenFieldsOption exportHiddenFieldsOption) {
        setExportHiddenFieldsOption(exportHiddenFieldsOption);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getExportHiddenFieldsOption() != null)
            sb.append("ExportHiddenFieldsOption: ").append(getExportHiddenFieldsOption());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DashboardVisualPublishOptions == false)
            return false;
        DashboardVisualPublishOptions other = (DashboardVisualPublishOptions) obj;
        if (other.getExportHiddenFieldsOption() == null ^ this.getExportHiddenFieldsOption() == null)
            return false;
        if (other.getExportHiddenFieldsOption() != null && other.getExportHiddenFieldsOption().equals(this.getExportHiddenFieldsOption()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getExportHiddenFieldsOption() == null) ? 0 : getExportHiddenFieldsOption().hashCode());
        return hashCode;
    }

    @Override
    public DashboardVisualPublishOptions clone() {
        try {
            return (DashboardVisualPublishOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.DashboardVisualPublishOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
