/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.proton.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.proton.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * EnvironmentAccountConnection JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EnvironmentAccountConnectionJsonUnmarshaller implements Unmarshaller<EnvironmentAccountConnection, JsonUnmarshallerContext> {

    public EnvironmentAccountConnection unmarshall(JsonUnmarshallerContext context) throws Exception {
        EnvironmentAccountConnection environmentAccountConnection = new EnvironmentAccountConnection();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("codebuildRoleArn", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setCodebuildRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("componentRoleArn", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setComponentRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("environmentAccountId", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setEnvironmentAccountId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("environmentName", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setEnvironmentName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastModifiedAt", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setLastModifiedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("managementAccountId", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setManagementAccountId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("requestedAt", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setRequestedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setRoleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    environmentAccountConnection.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return environmentAccountConnection;
    }

    private static EnvironmentAccountConnectionJsonUnmarshaller instance;

    public static EnvironmentAccountConnectionJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new EnvironmentAccountConnectionJsonUnmarshaller();
        return instance;
    }
}
