/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchInferenceJob"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateBatchInferenceJobResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of the batch inference job.
     * </p>
     */
    private String batchInferenceJobArn;

    /**
     * <p>
     * The ARN of the batch inference job.
     * </p>
     * 
     * @param batchInferenceJobArn
     *        The ARN of the batch inference job.
     */

    public void setBatchInferenceJobArn(String batchInferenceJobArn) {
        this.batchInferenceJobArn = batchInferenceJobArn;
    }

    /**
     * <p>
     * The ARN of the batch inference job.
     * </p>
     * 
     * @return The ARN of the batch inference job.
     */

    public String getBatchInferenceJobArn() {
        return this.batchInferenceJobArn;
    }

    /**
     * <p>
     * The ARN of the batch inference job.
     * </p>
     * 
     * @param batchInferenceJobArn
     *        The ARN of the batch inference job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchInferenceJobResult withBatchInferenceJobArn(String batchInferenceJobArn) {
        setBatchInferenceJobArn(batchInferenceJobArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBatchInferenceJobArn() != null)
            sb.append("BatchInferenceJobArn: ").append(getBatchInferenceJobArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateBatchInferenceJobResult == false)
            return false;
        CreateBatchInferenceJobResult other = (CreateBatchInferenceJobResult) obj;
        if (other.getBatchInferenceJobArn() == null ^ this.getBatchInferenceJobArn() == null)
            return false;
        if (other.getBatchInferenceJobArn() != null && other.getBatchInferenceJobArn().equals(this.getBatchInferenceJobArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBatchInferenceJobArn() == null) ? 0 : getBatchInferenceJobArn().hashCode());
        return hashCode;
    }

    @Override
    public CreateBatchInferenceJobResult clone() {
        try {
            return (CreateBatchInferenceJobResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
