/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.nimblestudio.AmazonNimbleStudio;
import com.amazonaws.services.nimblestudio.model.GetLaunchProfileRequest;
import com.amazonaws.services.nimblestudio.model.GetStreamingImageRequest;
import com.amazonaws.services.nimblestudio.model.GetStreamingSessionRequest;
import com.amazonaws.services.nimblestudio.model.GetStreamingSessionStreamRequest;
import com.amazonaws.services.nimblestudio.model.GetStudioComponentRequest;
import com.amazonaws.services.nimblestudio.model.GetStudioRequest;
import com.amazonaws.services.nimblestudio.waiters.GetLaunchProfileFunction;
import com.amazonaws.services.nimblestudio.waiters.GetStreamingImageFunction;
import com.amazonaws.services.nimblestudio.waiters.GetStreamingSessionFunction;
import com.amazonaws.services.nimblestudio.waiters.GetStreamingSessionStreamFunction;
import com.amazonaws.services.nimblestudio.waiters.GetStudioComponentFunction;
import com.amazonaws.services.nimblestudio.waiters.GetStudioFunction;
import com.amazonaws.services.nimblestudio.waiters.LaunchProfileDeleted;
import com.amazonaws.services.nimblestudio.waiters.LaunchProfileReady;
import com.amazonaws.services.nimblestudio.waiters.StreamingImageDeleted;
import com.amazonaws.services.nimblestudio.waiters.StreamingImageReady;
import com.amazonaws.services.nimblestudio.waiters.StreamingSessionDeleted;
import com.amazonaws.services.nimblestudio.waiters.StreamingSessionReady;
import com.amazonaws.services.nimblestudio.waiters.StreamingSessionStopped;
import com.amazonaws.services.nimblestudio.waiters.StreamingSessionStreamReady;
import com.amazonaws.services.nimblestudio.waiters.StudioComponentDeleted;
import com.amazonaws.services.nimblestudio.waiters.StudioComponentReady;
import com.amazonaws.services.nimblestudio.waiters.StudioDeleted;
import com.amazonaws.services.nimblestudio.waiters.StudioReady;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonNimbleStudioWaiters {
    private final AmazonNimbleStudio client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonNimbleStudioWaiters");

    @SdkInternalApi
    public AmazonNimbleStudioWaiters(AmazonNimbleStudio client) {
        this.client = client;
    }

    public Waiter<GetStreamingSessionRequest> streamingSessionDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingSessionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingSessionDeleted.IsDELETEDMatcher(), new StreamingSessionDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(180), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStudioComponentRequest> studioComponentDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStudioComponentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StudioComponentDeleted.IsDELETEDMatcher(), new StudioComponentDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStudioRequest> studioDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStudioFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StudioDeleted.IsDELETEDMatcher(), new StudioDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingSessionStreamRequest> streamingSessionStreamReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingSessionStreamFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingSessionStreamReady.IsREADYMatcher(), new StreamingSessionStreamReady.IsCREATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(30), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingImageRequest> streamingImageReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingImageFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingImageReady.IsREADYMatcher(), new StreamingImageReady.IsCREATE_FAILEDMatcher(), new StreamingImageReady.IsUPDATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetLaunchProfileRequest> launchProfileReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetLaunchProfileFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LaunchProfileReady.IsREADYMatcher(), new LaunchProfileReady.IsCREATE_FAILEDMatcher(), new LaunchProfileReady.IsUPDATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(150), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingSessionRequest> streamingSessionStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingSessionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingSessionStopped.IsSTOPPEDMatcher(), new StreamingSessionStopped.IsSTOP_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(180), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingImageRequest> streamingImageDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingImageFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingImageDeleted.IsDELETEDMatcher(), new StreamingImageDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStreamingSessionRequest> streamingSessionReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStreamingSessionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StreamingSessionReady.IsREADYMatcher(), new StreamingSessionReady.IsCREATE_FAILEDMatcher(), new StreamingSessionReady.IsSTART_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(180), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetLaunchProfileRequest> launchProfileDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetLaunchProfileFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new LaunchProfileDeleted.IsDELETEDMatcher(), new LaunchProfileDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(150), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStudioRequest> studioReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStudioFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StudioReady.IsREADYMatcher(), new StudioReady.IsCREATE_FAILEDMatcher(), new StudioReady.IsUPDATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetStudioComponentRequest> studioComponentReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetStudioComponentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StudioComponentReady.IsREADYMatcher(), new StudioComponentReady.IsCREATE_FAILEDMatcher(), new StudioComponentReady.IsUPDATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

