/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.Record;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetRecordsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Record> records;
    private String nextShardIterator;
    private Long millisBehindLatest;

    public List<Record> getRecords() {
        if (this.records == null) {
            this.records = new SdkInternalList();
        }
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new SdkInternalList(records);
    }

    public GetRecordsResult withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords((Collection<Record>)new SdkInternalList(records.length));
        }
        for (Record ele : records) {
            this.records.add((Object)ele);
        }
        return this;
    }

    public GetRecordsResult withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public void setNextShardIterator(String nextShardIterator) {
        this.nextShardIterator = nextShardIterator;
    }

    public String getNextShardIterator() {
        return this.nextShardIterator;
    }

    public GetRecordsResult withNextShardIterator(String nextShardIterator) {
        this.setNextShardIterator(nextShardIterator);
        return this;
    }

    public void setMillisBehindLatest(Long millisBehindLatest) {
        this.millisBehindLatest = millisBehindLatest;
    }

    public Long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }

    public GetRecordsResult withMillisBehindLatest(Long millisBehindLatest) {
        this.setMillisBehindLatest(millisBehindLatest);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: " + this.getRecords() + ",");
        }
        if (this.getNextShardIterator() != null) {
            sb.append("NextShardIterator: " + this.getNextShardIterator() + ",");
        }
        if (this.getMillisBehindLatest() != null) {
            sb.append("MillisBehindLatest: " + this.getMillisBehindLatest());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResult)) {
            return false;
        }
        GetRecordsResult other = (GetRecordsResult)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getNextShardIterator() == null ^ this.getNextShardIterator() == null) {
            return false;
        }
        if (other.getNextShardIterator() != null && !other.getNextShardIterator().equals(this.getNextShardIterator())) {
            return false;
        }
        if (other.getMillisBehindLatest() == null ^ this.getMillisBehindLatest() == null) {
            return false;
        }
        return other.getMillisBehindLatest() == null || other.getMillisBehindLatest().equals(this.getMillisBehindLatest());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextShardIterator() == null ? 0 : this.getNextShardIterator().hashCode());
        hashCode = 31 * hashCode + (this.getMillisBehindLatest() == null ? 0 : this.getMillisBehindLatest().hashCode());
        return hashCode;
    }

    public GetRecordsResult clone() {
        try {
            return (GetRecordsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

