/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes the effective recommendation preferences for Amazon EBS volumes.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/EBSEffectiveRecommendationPreferences"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EBSEffectiveRecommendationPreferences implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon EBS
     * volumes.
     * </p>
     */
    private EBSSavingsEstimationMode savingsEstimationMode;

    /**
     * <p>
     * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon EBS
     * volumes.
     * </p>
     * 
     * @param savingsEstimationMode
     *        Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon
     *        EBS volumes.
     */

    public void setSavingsEstimationMode(EBSSavingsEstimationMode savingsEstimationMode) {
        this.savingsEstimationMode = savingsEstimationMode;
    }

    /**
     * <p>
     * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon EBS
     * volumes.
     * </p>
     * 
     * @return Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon
     *         EBS volumes.
     */

    public EBSSavingsEstimationMode getSavingsEstimationMode() {
        return this.savingsEstimationMode;
    }

    /**
     * <p>
     * Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon EBS
     * volumes.
     * </p>
     * 
     * @param savingsEstimationMode
     *        Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon
     *        EBS volumes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EBSEffectiveRecommendationPreferences withSavingsEstimationMode(EBSSavingsEstimationMode savingsEstimationMode) {
        setSavingsEstimationMode(savingsEstimationMode);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSavingsEstimationMode() != null)
            sb.append("SavingsEstimationMode: ").append(getSavingsEstimationMode());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EBSEffectiveRecommendationPreferences == false)
            return false;
        EBSEffectiveRecommendationPreferences other = (EBSEffectiveRecommendationPreferences) obj;
        if (other.getSavingsEstimationMode() == null ^ this.getSavingsEstimationMode() == null)
            return false;
        if (other.getSavingsEstimationMode() != null && other.getSavingsEstimationMode().equals(this.getSavingsEstimationMode()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSavingsEstimationMode() == null) ? 0 : getSavingsEstimationMode().hashCode());
        return hashCode;
    }

    @Override
    public EBSEffectiveRecommendationPreferences clone() {
        try {
            return (EBSEffectiveRecommendationPreferences) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.computeoptimizer.model.transform.EBSEffectiveRecommendationPreferencesMarshaller.getInstance()
                .marshall(this, protocolMarshaller);
    }
}
