/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ForgotPasswordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ForgotPasswordRequestMarshaller
implements Marshaller<Request<ForgotPasswordRequest>, ForgotPasswordRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ForgotPasswordRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ForgotPasswordRequest> marshall(ForgotPasswordRequest forgotPasswordRequest) {
        if (forgotPasswordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)forgotPasswordRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ForgotPassword");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (forgotPasswordRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(forgotPasswordRequest.getClientId());
            }
            if (forgotPasswordRequest.getSecretHash() != null) {
                jsonGenerator.writeFieldName("SecretHash").writeValue(forgotPasswordRequest.getSecretHash());
            }
            if (forgotPasswordRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(forgotPasswordRequest.getUsername());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

