/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.BatchDescribeTypeConfigurationsRequest;
import com.amazonaws.services.cloudformation.model.TypeConfigurationIdentifier;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BatchDescribeTypeConfigurationsRequestMarshaller
implements Marshaller<Request<BatchDescribeTypeConfigurationsRequest>, BatchDescribeTypeConfigurationsRequest> {
    public Request<BatchDescribeTypeConfigurationsRequest> marshall(BatchDescribeTypeConfigurationsRequest batchDescribeTypeConfigurationsRequest) {
        if (batchDescribeTypeConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchDescribeTypeConfigurationsRequest, "AmazonCloudFormation");
        request.addParameter("Action", "BatchDescribeTypeConfigurations");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchDescribeTypeConfigurationsRequest.getTypeConfigurationIdentifiers().isEmpty() && !((SdkInternalList)batchDescribeTypeConfigurationsRequest.getTypeConfigurationIdentifiers()).isAutoConstruct()) {
            request.addParameter("TypeConfigurationIdentifiers", "");
        }
        if (!batchDescribeTypeConfigurationsRequest.getTypeConfigurationIdentifiers().isEmpty() || !((SdkInternalList)batchDescribeTypeConfigurationsRequest.getTypeConfigurationIdentifiers()).isAutoConstruct()) {
            SdkInternalList typeConfigurationIdentifiersList = (SdkInternalList)batchDescribeTypeConfigurationsRequest.getTypeConfigurationIdentifiers();
            int typeConfigurationIdentifiersListIndex = 1;
            for (TypeConfigurationIdentifier typeConfigurationIdentifiersListValue : typeConfigurationIdentifiersList) {
                if (typeConfigurationIdentifiersListValue != null) {
                    if (typeConfigurationIdentifiersListValue.getTypeArn() != null) {
                        request.addParameter("TypeConfigurationIdentifiers.member." + typeConfigurationIdentifiersListIndex + ".TypeArn", StringUtils.fromString((String)typeConfigurationIdentifiersListValue.getTypeArn()));
                    }
                    if (typeConfigurationIdentifiersListValue.getTypeConfigurationAlias() != null) {
                        request.addParameter("TypeConfigurationIdentifiers.member." + typeConfigurationIdentifiersListIndex + ".TypeConfigurationAlias", StringUtils.fromString((String)typeConfigurationIdentifiersListValue.getTypeConfigurationAlias()));
                    }
                    if (typeConfigurationIdentifiersListValue.getTypeConfigurationArn() != null) {
                        request.addParameter("TypeConfigurationIdentifiers.member." + typeConfigurationIdentifiersListIndex + ".TypeConfigurationArn", StringUtils.fromString((String)typeConfigurationIdentifiersListValue.getTypeConfigurationArn()));
                    }
                    if (typeConfigurationIdentifiersListValue.getType() != null) {
                        request.addParameter("TypeConfigurationIdentifiers.member." + typeConfigurationIdentifiersListIndex + ".Type", StringUtils.fromString((String)typeConfigurationIdentifiersListValue.getType()));
                    }
                    if (typeConfigurationIdentifiersListValue.getTypeName() != null) {
                        request.addParameter("TypeConfigurationIdentifiers.member." + typeConfigurationIdentifiersListIndex + ".TypeName", StringUtils.fromString((String)typeConfigurationIdentifiersListValue.getTypeName()));
                    }
                }
                ++typeConfigurationIdentifiersListIndex;
            }
        }
        return request;
    }
}

