/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apptest.model.MainframeActionProperties;
import com.amazonaws.services.apptest.model.MainframeResourceSummary;
import com.amazonaws.services.apptest.model.ScriptSummary;
import com.amazonaws.services.apptest.model.transform.TN3270StepInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TN3270StepInput
implements Serializable,
Cloneable,
StructuredPojo {
    private MainframeResourceSummary resource;
    private ScriptSummary script;
    private List<String> exportDataSetNames;
    private MainframeActionProperties properties;

    public void setResource(MainframeResourceSummary resource) {
        this.resource = resource;
    }

    public MainframeResourceSummary getResource() {
        return this.resource;
    }

    public TN3270StepInput withResource(MainframeResourceSummary resource) {
        this.setResource(resource);
        return this;
    }

    public void setScript(ScriptSummary script) {
        this.script = script;
    }

    public ScriptSummary getScript() {
        return this.script;
    }

    public TN3270StepInput withScript(ScriptSummary script) {
        this.setScript(script);
        return this;
    }

    public List<String> getExportDataSetNames() {
        return this.exportDataSetNames;
    }

    public void setExportDataSetNames(Collection<String> exportDataSetNames) {
        if (exportDataSetNames == null) {
            this.exportDataSetNames = null;
            return;
        }
        this.exportDataSetNames = new ArrayList<String>(exportDataSetNames);
    }

    public TN3270StepInput withExportDataSetNames(String ... exportDataSetNames) {
        if (this.exportDataSetNames == null) {
            this.setExportDataSetNames(new ArrayList<String>(exportDataSetNames.length));
        }
        for (String ele : exportDataSetNames) {
            this.exportDataSetNames.add(ele);
        }
        return this;
    }

    public TN3270StepInput withExportDataSetNames(Collection<String> exportDataSetNames) {
        this.setExportDataSetNames(exportDataSetNames);
        return this;
    }

    public void setProperties(MainframeActionProperties properties) {
        this.properties = properties;
    }

    public MainframeActionProperties getProperties() {
        return this.properties;
    }

    public TN3270StepInput withProperties(MainframeActionProperties properties) {
        this.setProperties(properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getScript() != null) {
            sb.append("Script: ").append(this.getScript()).append(",");
        }
        if (this.getExportDataSetNames() != null) {
            sb.append("ExportDataSetNames: ").append(this.getExportDataSetNames()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TN3270StepInput)) {
            return false;
        }
        TN3270StepInput other = (TN3270StepInput)obj;
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getScript() == null ^ this.getScript() == null) {
            return false;
        }
        if (other.getScript() != null && !other.getScript().equals(this.getScript())) {
            return false;
        }
        if (other.getExportDataSetNames() == null ^ this.getExportDataSetNames() == null) {
            return false;
        }
        if (other.getExportDataSetNames() != null && !other.getExportDataSetNames().equals(this.getExportDataSetNames())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getScript() == null ? 0 : this.getScript().hashCode());
        hashCode = 31 * hashCode + (this.getExportDataSetNames() == null ? 0 : this.getExportDataSetNames().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public TN3270StepInput clone() {
        try {
            return (TN3270StepInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TN3270StepInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

