/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.acmpca.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetPolicy" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetPolicyRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN
     * by calling the ListCertificateAuthorities action.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     */
    private String resourceArn;

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN
     * by calling the ListCertificateAuthorities action.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @param resourceArn
     *        The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the
     *        CA's ARN by calling the ListCertificateAuthorities action.
     * 
     *        <pre>
     * 
     *        <code> &lt;/p&gt; </code>
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN
     * by calling the ListCertificateAuthorities action.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @return The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the
     *         CA's ARN by calling the ListCertificateAuthorities action.
     * 
     *         <pre>
     * 
     *         <code> &lt;/p&gt; </code>
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the CA's ARN
     * by calling the ListCertificateAuthorities action.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @param resourceArn
     *        The Amazon Resource Number (ARN) of the private CA that will have its policy retrieved. You can find the
     *        CA's ARN by calling the ListCertificateAuthorities action.
     * 
     *        <pre>
     * 
     *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be chained
     *        together.
     */

    public GetPolicyRequest withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetPolicyRequest == false)
            return false;
        GetPolicyRequest other = (GetPolicyRequest) obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        return hashCode;
    }

    @Override
    public GetPolicyRequest clone() {
        return (GetPolicyRequest) super.clone();
    }

}
