/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeSortUtils;
import com.alibaba.p3c.pmd.lang.java.util.VariableUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.MultiLineComment;
import net.sourceforge.pmd.lang.java.ast.SingleLineComment;
import net.sourceforge.pmd.lang.java.ast.Token;
import org.apache.commons.lang3.StringUtils;

public class CommentsMustBeJavadocFormatRule
extends AbstractAliCommentRule {
    private static final String MESSAGE_KEY_PREFIX = "java.comment.CommentsMustBeJavadocFormatRule.violation.msg";

    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        this.checkComment((AbstractJavaAccessNode)decl, data, () -> I18nResources.getMessage("java.comment.CommentsMustBeJavadocFormatRule.violation.msg.class", decl.getImage()));
        return super.visit(decl, data);
    }

    public Object visit(ASTConstructorDeclaration decl, Object data) {
        this.checkComment((AbstractJavaAccessNode)decl, data, () -> {
            String constructorName = ((Token)decl.jjtGetFirstToken()).image;
            if (decl.getFormalParameters().getParameterCount() == 0) {
                return I18nResources.getMessage("java.comment.CommentsMustBeJavadocFormatRule.violation.msg.constructor.default", constructorName);
            }
            List formalParameters = decl.getFormalParameters().findChildrenOfType(ASTFormalParameter.class);
            ArrayList<String> strings = new ArrayList<String>(formalParameters.size());
            for (ASTFormalParameter formalParameter : formalParameters) {
                strings.add(formalParameter.jjtGetFirstToken().toString() + " " + formalParameter.jjtGetLastToken().toString());
            }
            return I18nResources.getMessage("java.comment.CommentsMustBeJavadocFormatRule.violation.msg.constructor.parameter", constructorName, StringUtils.join(strings, (String)","));
        });
        return super.visit(decl, data);
    }

    public Object visit(ASTMethodDeclaration decl, Object data) {
        this.checkComment((AbstractJavaAccessNode)decl, data, () -> I18nResources.getMessage("java.comment.CommentsMustBeJavadocFormatRule.violation.msg.method", decl.getMethodName()));
        return super.visit(decl, data);
    }

    public Object visit(ASTFieldDeclaration decl, Object data) {
        this.checkComment((AbstractJavaAccessNode)decl, data, () -> I18nResources.getMessage("java.comment.CommentsMustBeJavadocFormatRule.violation.msg.field", VariableUtils.getVariableName((AbstractJavaAccessNode)decl)));
        return super.visit(decl, data);
    }

    public Object visit(ASTEnumDeclaration decl, Object data) {
        this.checkComment((AbstractJavaAccessNode)decl, data, () -> I18nResources.getMessage("java.comment.CommentsMustBeJavadocFormatRule.violation.msg.enum", decl.getImage()));
        return super.visit(decl, data);
    }

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }

    private void checkComment(AbstractJavaAccessNode decl, Object data, MessageMaker maker) {
        Comment comment = decl.comment();
        if (comment instanceof SingleLineComment || comment instanceof MultiLineComment) {
            this.addViolationWithMessage(data, (Node)decl, maker.make(), comment.getBeginLine(), comment.getEndLine());
        }
    }

    protected void assignCommentsToDeclarations(ASTCompilationUnit cUnit) {
        SortedMap<Integer, Node> itemsByLineNumber = this.orderedComments(cUnit);
        Comment lastComment = null;
        AbstractJavaNode lastNode = null;
        for (Map.Entry<Integer, Node> entry : itemsByLineNumber.entrySet()) {
            Node value = entry.getValue();
            if (value instanceof AbstractJavaNode) {
                AbstractJavaNode node = (AbstractJavaNode)value;
                if (node instanceof ASTAnnotation) continue;
                if (lastComment != null && this.isCommentOneLineBefore(itemsByLineNumber, lastComment, (Node)lastNode, (Node)node)) {
                    node.comment(lastComment);
                    lastComment = null;
                }
                lastNode = node;
                continue;
            }
            if (!(value instanceof Comment)) continue;
            lastComment = (Comment)value;
        }
    }

    protected SortedMap<Integer, Node> orderedComments(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, cUnit.getComments());
        List annotations = cUnit.findDescendantsOfType(ASTAnnotation.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, annotations);
        List classDecl = cUnit.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, classDecl);
        List fields = cUnit.findDescendantsOfType(ASTFieldDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, fields);
        List methods = cUnit.findDescendantsOfType(ASTMethodDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, methods);
        List constructors = cUnit.findDescendantsOfType(ASTConstructorDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, constructors);
        List enumDecl = cUnit.findDescendantsOfType(ASTEnumDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, enumDecl);
        return itemsByLineNumber;
    }

    private boolean isCommentOneLineBefore(SortedMap<Integer, Node> items, Comment lastComment, Node lastNode, Node node) {
        ASTClassOrInterfaceBodyDeclaration parentClass = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        if (parentClass != null && parentClass.isAnonymousInnerClass()) {
            return false;
        }
        if (lastNode != null && lastNode.getEndLine() == lastComment.getEndLine()) {
            return false;
        }
        SortedMap<Integer, Node> subMap = items.subMap(NodeSortUtils.generateIndex((Node)lastComment), NodeSortUtils.generateIndex(node));
        Iterator<Map.Entry<Integer, Node>> iter = subMap.entrySet().iterator();
        iter.next();
        int lastEndLine = lastComment.getEndLine();
        while (iter.hasNext()) {
            Map.Entry<Integer, Node> entry = iter.next();
            Node value = entry.getValue();
            if (!(value instanceof ASTAnnotation)) {
                return false;
            }
            if (lastEndLine + 1 != value.getBeginLine()) continue;
            lastEndLine = value.getEndLine();
        }
        return lastEndLine + 1 == node.getBeginLine();
    }

    static interface MessageMaker {
        public String make();
    }
}

