/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonDataImpl;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.EnumSet;

@JsonpDeserializable
public interface JsonData
extends JsonpSerializable {
    public static final JsonpDeserializer<JsonData> _DESERIALIZER = JsonpDeserializer.of(EnumSet.allOf(JsonParser.Event.class), (JsonParser parser, JsonpMapper mapper, JsonParser.Event event) -> JsonData.from(parser, mapper, event));

    public JsonValue toJson();

    public JsonValue toJson(JsonpMapper var1);

    public <T> T to(Class<T> var1);

    public <T> T to(Class<T> var1, JsonpMapper var2);

    public <T> T deserialize(JsonpDeserializer<T> var1);

    public <T> T deserialize(JsonpDeserializer<T> var1, JsonpMapper var2);

    public static <T> JsonData of(T value) {
        if (value instanceof JsonData) {
            return (JsonData)value;
        }
        return new JsonDataImpl(value, null);
    }

    public static <T> JsonData of(T value, JsonpMapper mapper) {
        return new JsonDataImpl(value, mapper);
    }

    public static JsonData fromJson(String json) {
        return JsonData.from(new StringReader(json));
    }

    public static JsonData from(Reader json) {
        JsonProvider provider = JsonpUtils.provider();
        try (JsonParser parser = provider.createParser(json);){
            parser.next();
            JsonDataImpl jsonDataImpl = new JsonDataImpl(parser.getValue(), null);
            return jsonDataImpl;
        }
    }

    public static JsonData from(InputStream json) {
        JsonProvider provider = JsonpUtils.provider();
        try (JsonParser parser = provider.createParser(json);){
            parser.next();
            JsonDataImpl jsonDataImpl = new JsonDataImpl(parser.getValue(), null);
            return jsonDataImpl;
        }
    }

    public static JsonData from(JsonParser parser, JsonpMapper mapper) {
        parser.next();
        return JsonData.of(parser.getValue(), mapper);
    }

    public static JsonData from(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        return JsonData.of(parser.getValue(), mapper);
    }
}

