/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.SignificantStringTermsBucket;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SignificantStringTermsAggregate
extends MultiBucketAggregateBase<SignificantStringTermsBucket>
implements AggregateVariant {
    @Nullable
    private final Long bgCount;
    @Nullable
    private final Long docCount;
    public static final JsonpDeserializer<SignificantStringTermsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SignificantStringTermsAggregate::setupSignificantStringTermsAggregateDeserializer);

    private SignificantStringTermsAggregate(Builder builder) {
        super(builder);
        this.bgCount = builder.bgCount;
        this.docCount = builder.docCount;
    }

    public static SignificantStringTermsAggregate of(Function<Builder, ObjectBuilder<SignificantStringTermsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Sigsterms;
    }

    @Nullable
    public final Long bgCount() {
        return this.bgCount;
    }

    @Nullable
    public final Long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bgCount != null) {
            generator.writeKey("bg_count");
            generator.write(this.bgCount.longValue());
        }
        if (this.docCount != null) {
            generator.writeKey("doc_count");
            generator.write(this.docCount.longValue());
        }
    }

    protected static void setupSignificantStringTermsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, SignificantStringTermsBucket._DESERIALIZER);
        op.add(Builder::bgCount, JsonpDeserializer.longDeserializer(), "bg_count");
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
    }

    public static class Builder
    extends MultiBucketAggregateBase.AbstractBuilder<SignificantStringTermsBucket, Builder>
    implements ObjectBuilder<SignificantStringTermsAggregate> {
        @Nullable
        private Long bgCount;
        @Nullable
        private Long docCount;

        public final Builder bgCount(@Nullable Long value) {
            this.bgCount = value;
            return this;
        }

        public final Builder docCount(@Nullable Long value) {
            this.docCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SignificantStringTermsAggregate build() {
            this._checkSingleUse();
            super.tBucketSerializer(null);
            return new SignificantStringTermsAggregate(this);
        }
    }
}

