/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.elasticsearch.indices.stats.IndexStats;
import co.elastic.clients.elasticsearch.indices.stats.ShardStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicesStats
implements JsonpSerializable {
    @Nullable
    private final IndexStats primaries;
    private final Map<String, List<ShardStats>> shards;
    @Nullable
    private final IndexStats total;
    @Nullable
    private final String uuid;
    public static final JsonpDeserializer<IndicesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesStats::setupIndicesStatsDeserializer);

    private IndicesStats(Builder builder) {
        this.primaries = builder.primaries;
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.total = builder.total;
        this.uuid = builder.uuid;
    }

    public static IndicesStats of(Function<Builder, ObjectBuilder<IndicesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final IndexStats primaries() {
        return this.primaries;
    }

    public final Map<String, List<ShardStats>> shards() {
        return this.shards;
    }

    @Nullable
    public final IndexStats total() {
        return this.total;
    }

    @Nullable
    public final String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.primaries != null) {
            generator.writeKey("primaries");
            this.primaries.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, List<ShardStats>> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (ShardStats item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
        if (this.uuid != null) {
            generator.writeKey("uuid");
            generator.write(this.uuid);
        }
    }

    protected static void setupIndicesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::primaries, IndexStats._DESERIALIZER, "primaries");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardStats._DESERIALIZER)), "shards");
        op.add(Builder::total, IndexStats._DESERIALIZER, "total");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndicesStats> {
        @Nullable
        private IndexStats primaries;
        @Nullable
        private Map<String, List<ShardStats>> shards;
        @Nullable
        private IndexStats total;
        @Nullable
        private String uuid;

        public final Builder primaries(@Nullable IndexStats value) {
            this.primaries = value;
            return this;
        }

        public final Builder primaries(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.primaries(fn.apply(new IndexStats.Builder()).build());
        }

        public final Builder shards(Map<String, List<ShardStats>> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        public final Builder shards(String key, List<ShardStats> value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        public final Builder total(@Nullable IndexStats value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.total(fn.apply(new IndexStats.Builder()).build());
        }

        public final Builder uuid(@Nullable String value) {
            this.uuid = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicesStats build() {
            this._checkSingleUse();
            return new IndicesStats(this);
        }
    }
}

