/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.close;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class CloseShardResult
implements JsonpSerializable {
    private final List<ShardFailure> failures;
    public static final JsonpDeserializer<CloseShardResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseShardResult::setupCloseShardResultDeserializer);

    private CloseShardResult(Builder builder) {
        this.failures = ApiTypeHelper.unmodifiableRequired(builder.failures, (Object)this, "failures");
    }

    public static CloseShardResult of(Function<Builder, ObjectBuilder<CloseShardResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ShardFailure> failures() {
        return this.failures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCloseShardResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CloseShardResult> {
        private List<ShardFailure> failures;

        public final Builder failures(List<ShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(ShardFailure value, ShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build(), new ShardFailure[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CloseShardResult build() {
            this._checkSingleUse();
            return new CloseShardResult(this);
        }
    }
}

