/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.ShardProfile;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Profile
implements JsonpSerializable {
    private final List<ShardProfile> shards;
    public static final JsonpDeserializer<Profile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Profile::setupProfileDeserializer);

    private Profile(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static Profile of(Function<Builder, ObjectBuilder<Profile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ShardProfile> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartArray();
            for (ShardProfile item0 : this.shards) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(ShardProfile._DESERIALIZER), "shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Profile> {
        private List<ShardProfile> shards;

        public final Builder shards(List<ShardProfile> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        public final Builder shards(ShardProfile value, ShardProfile ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        public final Builder shards(Function<ShardProfile.Builder, ObjectBuilder<ShardProfile>> fn) {
            return this.shards(fn.apply(new ShardProfile.Builder()).build(), new ShardProfile[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Profile build() {
            this._checkSingleUse();
            return new Profile(this);
        }
    }
}

