/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterNodeCount
implements JsonpSerializable {
    private final int coordinatingOnly;
    private final int data;
    private final int ingest;
    private final int master;
    private final int total;
    private final int votingOnly;
    private final int dataCold;
    @Nullable
    private final Integer dataFrozen;
    private final int dataContent;
    private final int dataWarm;
    private final int dataHot;
    private final int ml;
    private final int remoteClusterClient;
    private final int transform;
    public static final JsonpDeserializer<ClusterNodeCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNodeCount::setupClusterNodeCountDeserializer);

    private ClusterNodeCount(Builder builder) {
        this.coordinatingOnly = ApiTypeHelper.requireNonNull(builder.coordinatingOnly, this, "coordinatingOnly");
        this.data = ApiTypeHelper.requireNonNull(builder.data, this, "data");
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.master = ApiTypeHelper.requireNonNull(builder.master, this, "master");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.votingOnly = ApiTypeHelper.requireNonNull(builder.votingOnly, this, "votingOnly");
        this.dataCold = ApiTypeHelper.requireNonNull(builder.dataCold, this, "dataCold");
        this.dataFrozen = builder.dataFrozen;
        this.dataContent = ApiTypeHelper.requireNonNull(builder.dataContent, this, "dataContent");
        this.dataWarm = ApiTypeHelper.requireNonNull(builder.dataWarm, this, "dataWarm");
        this.dataHot = ApiTypeHelper.requireNonNull(builder.dataHot, this, "dataHot");
        this.ml = ApiTypeHelper.requireNonNull(builder.ml, this, "ml");
        this.remoteClusterClient = ApiTypeHelper.requireNonNull(builder.remoteClusterClient, this, "remoteClusterClient");
        this.transform = ApiTypeHelper.requireNonNull(builder.transform, this, "transform");
    }

    public static ClusterNodeCount of(Function<Builder, ObjectBuilder<ClusterNodeCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int coordinatingOnly() {
        return this.coordinatingOnly;
    }

    public final int data() {
        return this.data;
    }

    public final int ingest() {
        return this.ingest;
    }

    public final int master() {
        return this.master;
    }

    public final int total() {
        return this.total;
    }

    public final int votingOnly() {
        return this.votingOnly;
    }

    public final int dataCold() {
        return this.dataCold;
    }

    @Nullable
    public final Integer dataFrozen() {
        return this.dataFrozen;
    }

    public final int dataContent() {
        return this.dataContent;
    }

    public final int dataWarm() {
        return this.dataWarm;
    }

    public final int dataHot() {
        return this.dataHot;
    }

    public final int ml() {
        return this.ml;
    }

    public final int remoteClusterClient() {
        return this.remoteClusterClient;
    }

    public final int transform() {
        return this.transform;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("coordinating_only");
        generator.write(this.coordinatingOnly);
        generator.writeKey("data");
        generator.write(this.data);
        generator.writeKey("ingest");
        generator.write(this.ingest);
        generator.writeKey("master");
        generator.write(this.master);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("voting_only");
        generator.write(this.votingOnly);
        generator.writeKey("data_cold");
        generator.write(this.dataCold);
        if (this.dataFrozen != null) {
            generator.writeKey("data_frozen");
            generator.write(this.dataFrozen.intValue());
        }
        generator.writeKey("data_content");
        generator.write(this.dataContent);
        generator.writeKey("data_warm");
        generator.write(this.dataWarm);
        generator.writeKey("data_hot");
        generator.write(this.dataHot);
        generator.writeKey("ml");
        generator.write(this.ml);
        generator.writeKey("remote_cluster_client");
        generator.write(this.remoteClusterClient);
        generator.writeKey("transform");
        generator.write(this.transform);
    }

    protected static void setupClusterNodeCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::coordinatingOnly, JsonpDeserializer.integerDeserializer(), "coordinating_only");
        op.add(Builder::data, JsonpDeserializer.integerDeserializer(), "data");
        op.add(Builder::ingest, JsonpDeserializer.integerDeserializer(), "ingest");
        op.add(Builder::master, JsonpDeserializer.integerDeserializer(), "master");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::votingOnly, JsonpDeserializer.integerDeserializer(), "voting_only");
        op.add(Builder::dataCold, JsonpDeserializer.integerDeserializer(), "data_cold");
        op.add(Builder::dataFrozen, JsonpDeserializer.integerDeserializer(), "data_frozen");
        op.add(Builder::dataContent, JsonpDeserializer.integerDeserializer(), "data_content");
        op.add(Builder::dataWarm, JsonpDeserializer.integerDeserializer(), "data_warm");
        op.add(Builder::dataHot, JsonpDeserializer.integerDeserializer(), "data_hot");
        op.add(Builder::ml, JsonpDeserializer.integerDeserializer(), "ml");
        op.add(Builder::remoteClusterClient, JsonpDeserializer.integerDeserializer(), "remote_cluster_client");
        op.add(Builder::transform, JsonpDeserializer.integerDeserializer(), "transform");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterNodeCount> {
        private Integer coordinatingOnly;
        private Integer data;
        private Integer ingest;
        private Integer master;
        private Integer total;
        private Integer votingOnly;
        private Integer dataCold;
        @Nullable
        private Integer dataFrozen;
        private Integer dataContent;
        private Integer dataWarm;
        private Integer dataHot;
        private Integer ml;
        private Integer remoteClusterClient;
        private Integer transform;

        public final Builder coordinatingOnly(int value) {
            this.coordinatingOnly = value;
            return this;
        }

        public final Builder data(int value) {
            this.data = value;
            return this;
        }

        public final Builder ingest(int value) {
            this.ingest = value;
            return this;
        }

        public final Builder master(int value) {
            this.master = value;
            return this;
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder votingOnly(int value) {
            this.votingOnly = value;
            return this;
        }

        public final Builder dataCold(int value) {
            this.dataCold = value;
            return this;
        }

        public final Builder dataFrozen(@Nullable Integer value) {
            this.dataFrozen = value;
            return this;
        }

        public final Builder dataContent(int value) {
            this.dataContent = value;
            return this;
        }

        public final Builder dataWarm(int value) {
            this.dataWarm = value;
            return this;
        }

        public final Builder dataHot(int value) {
            this.dataHot = value;
            return this;
        }

        public final Builder ml(int value) {
            this.ml = value;
            return this;
        }

        public final Builder remoteClusterClient(int value) {
            this.remoteClusterClient = value;
            return this;
        }

        public final Builder transform(int value) {
            this.transform = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterNodeCount build() {
            this._checkSingleUse();
            return new ClusterNodeCount(this);
        }
    }
}

