/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.TermsBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StringTermsBucket
extends TermsBucketBase {
    private final String key;
    public static final JsonpDeserializer<StringTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StringTermsBucket::setupStringTermsBucketDeserializer);

    private StringTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static StringTermsBucket of(Function<Builder, ObjectBuilder<StringTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
    }

    protected static void setupStringTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        TermsBucketBase.setupTermsBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
    }

    public static class Builder
    extends TermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StringTermsBucket> {
        private String key;

        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StringTermsBucket build() {
            this._checkSingleUse();
            return new StringTermsBucket(this);
        }
    }
}

