/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiTermsBucket
extends MultiBucketBase {
    private final List<String> key;
    @Nullable
    private final String keyAsString;
    @Nullable
    private final Long docCountErrorUpperBound;
    public static final JsonpDeserializer<MultiTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermsBucket::setupMultiTermsBucketDeserializer);

    private MultiTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.unmodifiableRequired(builder.key, (Object)this, "key");
        this.keyAsString = builder.keyAsString;
        this.docCountErrorUpperBound = builder.docCountErrorUpperBound;
    }

    public static MultiTermsBucket of(Function<Builder, ObjectBuilder<MultiTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> key() {
        return this.key;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Nullable
    public final Long docCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.key)) {
            generator.writeKey("key");
            generator.writeStartArray();
            for (String item0 : this.key) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
        if (this.docCountErrorUpperBound != null) {
            generator.writeKey("doc_count_error_upper_bound");
            generator.write(this.docCountErrorUpperBound.longValue());
        }
    }

    protected static void setupMultiTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "key");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
        op.add(Builder::docCountErrorUpperBound, JsonpDeserializer.longDeserializer(), "doc_count_error_upper_bound");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiTermsBucket> {
        private List<String> key;
        @Nullable
        private String keyAsString;
        @Nullable
        private Long docCountErrorUpperBound;

        public final Builder key(List<String> list) {
            this.key = Builder._listAddAll(this.key, list);
            return this;
        }

        public final Builder key(String value, String ... values) {
            this.key = Builder._listAdd(this.key, value, values);
            return this;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        public final Builder docCountErrorUpperBound(@Nullable Long value) {
            this.docCountErrorUpperBound = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiTermsBucket build() {
            this._checkSingleUse();
            return new MultiTermsBucket(this);
        }
    }
}

