/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryCacheStats
implements JsonpSerializable {
    private final int cacheCount;
    private final int cacheSize;
    private final int evictions;
    private final int hitCount;
    @Nullable
    private final String memorySize;
    private final int memorySizeInBytes;
    private final int missCount;
    private final int totalCount;
    public static final JsonpDeserializer<QueryCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryCacheStats::setupQueryCacheStatsDeserializer);

    private QueryCacheStats(Builder builder) {
        this.cacheCount = ApiTypeHelper.requireNonNull(builder.cacheCount, this, "cacheCount");
        this.cacheSize = ApiTypeHelper.requireNonNull(builder.cacheSize, this, "cacheSize");
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
        this.hitCount = ApiTypeHelper.requireNonNull(builder.hitCount, this, "hitCount");
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, this, "memorySizeInBytes");
        this.missCount = ApiTypeHelper.requireNonNull(builder.missCount, this, "missCount");
        this.totalCount = ApiTypeHelper.requireNonNull(builder.totalCount, this, "totalCount");
    }

    public static QueryCacheStats of(Function<Builder, ObjectBuilder<QueryCacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int cacheCount() {
        return this.cacheCount;
    }

    public final int cacheSize() {
        return this.cacheSize;
    }

    public final int evictions() {
        return this.evictions;
    }

    public final int hitCount() {
        return this.hitCount;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final int memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final int missCount() {
        return this.missCount;
    }

    public final int totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_count");
        generator.write(this.cacheCount);
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    protected static void setupQueryCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheCount, JsonpDeserializer.integerDeserializer(), "cache_count");
        op.add(Builder::cacheSize, JsonpDeserializer.integerDeserializer(), "cache_size");
        op.add(Builder::evictions, JsonpDeserializer.integerDeserializer(), "evictions");
        op.add(Builder::hitCount, JsonpDeserializer.integerDeserializer(), "hit_count");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.integerDeserializer(), "memory_size_in_bytes");
        op.add(Builder::missCount, JsonpDeserializer.integerDeserializer(), "miss_count");
        op.add(Builder::totalCount, JsonpDeserializer.integerDeserializer(), "total_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryCacheStats> {
        private Integer cacheCount;
        private Integer cacheSize;
        private Integer evictions;
        private Integer hitCount;
        @Nullable
        private String memorySize;
        private Integer memorySizeInBytes;
        private Integer missCount;
        private Integer totalCount;

        public final Builder cacheCount(int value) {
            this.cacheCount = value;
            return this;
        }

        public final Builder cacheSize(int value) {
            this.cacheSize = value;
            return this;
        }

        public final Builder evictions(int value) {
            this.evictions = value;
            return this;
        }

        public final Builder hitCount(int value) {
            this.hitCount = value;
            return this;
        }

        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public final Builder memorySizeInBytes(int value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public final Builder missCount(int value) {
            this.missCount = value;
            return this;
        }

        public final Builder totalCount(int value) {
            this.totalCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryCacheStats build() {
            this._checkSingleUse();
            return new QueryCacheStats(this);
        }
    }
}

