/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.browsermob.proxy.util.ChainableWriter;

public class LockingChainingWriter
extends ChainableWriter {
    private ReentrantLock lock = new ReentrantLock();
    private File file;

    public LockingChainingWriter(File file) throws IOException {
        super(new FileWriter(file));
        this.file = file;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSafely() throws IOException {
        try {
            this.lock();
            this.close();
        }
        finally {
            this.unlock();
        }
    }

    public void delete() {
        this.file.delete();
    }

    public File getFile() {
        return this.file;
    }
}

