/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.log;

public class Frame {
    private static String __className = Frame.class.getName();
    private static final String __lineSeparator = System.getProperty("line.separator");
    private StackTraceElement[] _stack;
    private String _string;
    private String _method = "unknownMethod";
    private int _depth = 0;
    private String _thread = "unknownThread";
    private String _file = "UnknownFile";
    private String _where;
    private int _top = 0;

    public Frame() {
        this._stack = new Throwable().getStackTrace();
        this.init(0, false);
    }

    public Frame(int ignoreFrames) {
        this._stack = new Throwable().getStackTrace();
        this.init(ignoreFrames, false);
    }

    Frame(int ignoreFrames, boolean partial) {
        this._stack = new Throwable().getStackTrace();
        this.init(ignoreFrames, partial);
    }

    private Frame(StackTraceElement[] stack, int top) {
        this._stack = stack;
        this._top = top;
        this._where = this._stack[this._top].toString();
        this.complete();
    }

    private void init(int ignoreFrames, boolean partial) {
        int check = this._stack.length;
        if (check > 3) {
            check = 3;
        }
        for (int i = 0; i < check; ++i) {
            if (!__className.equals(this._stack[i].getClassName()) || !"<init>".equalsIgnoreCase(this._stack[i].getMethodName())) continue;
            this._top = i + 1;
            break;
        }
        this._top += ignoreFrames;
        this._where = this._stack[this._top].toString();
        if (!partial) {
            this.complete();
        }
    }

    void complete() {
        this._file = this._stack[this._top].getFileName() + ":" + this._stack[this._top].getLineNumber();
        this._method = this._stack[this._top].getClassName() + "." + this._stack[this._top].getMethodName();
        this._depth = this._stack.length - this._top;
        this._thread = Thread.currentThread().getName();
    }

    public StackTraceElement getStackTraceElement() {
        return this._stack[this._top];
    }

    public String getStack() {
        if (this._string == null) {
            StringBuffer buf = new StringBuffer(512);
            for (int i = 0; i < this._stack.length; ++i) {
                if (i > this._top) {
                    buf.append(__lineSeparator);
                }
                buf.append(this._stack[i].toString());
            }
            this._string = buf.toString();
        }
        return this._string;
    }

    public String getMethod() {
        if (this._method == null) {
            this.complete();
        }
        return this._method;
    }

    public int getDepth() {
        if (this._thread == null) {
            this.complete();
        }
        return this._depth;
    }

    public String getThread() {
        if (this._thread == null) {
            this.complete();
        }
        return this._thread;
    }

    public String getFile() {
        if (this._file == null) {
            this.complete();
        }
        return this._file;
    }

    public String getWhere() {
        return this._where;
    }

    public String toString() {
        if (this._thread == null) {
            this.complete();
        }
        return "[" + this._thread + "] " + this._method + "(" + this._file + ")";
    }

    public Frame getParent() {
        if (this._top + 1 >= this._stack.length) {
            return null;
        }
        return new Frame(this._stack, this._top + 1);
    }
}

