/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.html;

import java.util.Hashtable;
import org.browsermob.proxy.jetty.html.Block;
import org.browsermob.proxy.jetty.html.CompositeFactory;

public class Table
extends Block {
    private Block row = null;
    private Block cell = null;
    private static Hashtable threadNestingMap = null;
    private CompositeFactory cellNestFactory = null;
    private Block _defaultHead = null;
    private Block _defaultCell = null;
    private Block _defaultRow = null;

    public Table() {
        super("table");
        if (threadNestingMap != null) {
            this.cellNestFactory = (CompositeFactory)threadNestingMap.get(Thread.currentThread());
        }
    }

    public Table(int border) {
        super("table");
        this.attribute("border", border);
        if (threadNestingMap != null) {
            this.cellNestFactory = (CompositeFactory)threadNestingMap.get(Thread.currentThread());
        }
    }

    public Table(int border, String attributes) {
        this(border);
        this.attribute(attributes);
    }

    public Table newRow() {
        this.unnest();
        this.row = new Block("tr");
        this.nest(this.row);
        if (this._defaultRow != null) {
            this.row.setAttributesFrom(this._defaultRow);
            if (this._defaultRow.size() > 0) {
                this.row.add(this._defaultRow.contents());
            }
        }
        this.cell = null;
        return this;
    }

    public Table newRow(String attributes) {
        this.newRow();
        this.row.attribute(attributes);
        return this;
    }

    private void newBlock(String m) {
        if (this.row == null) {
            this.newRow();
        } else {
            this.row.unnest();
        }
        this.cell = new Block(m);
        this.row.nest(this.cell);
        if (this.cellNestFactory != null) {
            this.cell.nest(this.cellNestFactory.newComposite());
        }
    }

    public Table newCell() {
        this.newBlock("td");
        if (this._defaultCell != null) {
            this.cell.setAttributesFrom(this._defaultCell);
            if (this._defaultCell.size() > 0) {
                this.cell.add(this._defaultCell.contents());
            }
        }
        return this;
    }

    public Table newCell(String attributes) {
        this.newCell();
        this.cell.attribute(attributes);
        return this;
    }

    public Table addCell(Object o) {
        this.newCell();
        this.cell.add(o);
        return this;
    }

    public Table addCell(Object o, String attributes) {
        this.addCell(o);
        this.cell.attribute(attributes);
        return this;
    }

    public Table newHeading() {
        this.newBlock("th");
        if (this._defaultHead != null) {
            this.cell.setAttributesFrom(this._defaultHead);
            if (this._defaultHead.size() > 0) {
                this.cell.add(this._defaultHead.contents());
            }
        }
        return this;
    }

    public Table addHeading(Object o) {
        this.newHeading();
        this.cell.add(o);
        return this;
    }

    public Table addHeading(Object o, String attributes) {
        this.addHeading(o);
        this.cell.attribute(attributes);
        return this;
    }

    public Table cellSpacing(int s) {
        this.attribute("cellspacing", s);
        return this;
    }

    public Table cellPadding(int padding) {
        this.attribute("cellpadding", padding);
        return this;
    }

    public Table spacing(int h, int v) {
        if (h >= 0) {
            this.attribute("hspace", h);
        }
        if (v >= 0) {
            this.attribute("vspace", v);
        }
        return this;
    }

    public Block row() {
        return this.row;
    }

    public Block cell() {
        return this.cell;
    }

    public static void setCellNestingFactory(CompositeFactory factory) {
        if (threadNestingMap == null) {
            threadNestingMap = new Hashtable();
        }
        if (factory == null) {
            threadNestingMap.remove(Thread.currentThread());
        } else {
            threadNestingMap.put(Thread.currentThread(), factory);
        }
    }

    public static void setThreadNestingFactory(CompositeFactory factory) {
        if (threadNestingMap == null) {
            threadNestingMap = new Hashtable();
        }
        if (factory == null) {
            threadNestingMap.remove(Thread.currentThread());
        } else {
            threadNestingMap.put(Thread.currentThread(), factory);
        }
    }

    public void setNestingFactory(CompositeFactory factory) {
        this.cellNestFactory = factory;
    }

    public Block defaultRow() {
        if (this._defaultRow == null) {
            this._defaultRow = new Block("tr");
        }
        return this._defaultRow;
    }

    public Block defaultHead() {
        if (this._defaultHead == null) {
            this._defaultHead = new Block("th");
        }
        return this._defaultHead;
    }

    public Block defaultCell() {
        if (this._defaultCell == null) {
            this._defaultCell = new Block("td");
        }
        return this._defaultCell;
    }
}

