/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class AnnotationAttributeMatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean complement;
    private final ImmutableSet<String> wholeTypes;
    private final ImmutableSetMultimap<String, String> includedAttributes;
    private final ImmutableSetMultimap<String, String> excludedAttributes;

    private AnnotationAttributeMatcher(boolean complement, ImmutableSet<String> wholeTypes, ImmutableSetMultimap<String, String> includedAttributes, ImmutableSetMultimap<String, String> excludedAttributes) {
        this.complement = complement;
        this.wholeTypes = wholeTypes;
        this.includedAttributes = includedAttributes;
        this.excludedAttributes = excludedAttributes;
    }

    public static AnnotationAttributeMatcher create(Optional<? extends List<String>> inclusions, Iterable<String> exclusions) {
        HashSet includedWholeTypes = new HashSet();
        HashSet<String> excludedWholeTypes = new HashSet<String>();
        HashMultimap includedAttributes = HashMultimap.create();
        HashMultimap excludedAttributes = HashMultimap.create();
        inclusions.ifPresent(arg_0 -> AnnotationAttributeMatcher.lambda$create$0(includedWholeTypes, (SetMultimap)includedAttributes, arg_0));
        AnnotationAttributeMatcher.update(exclusions, excludedWholeTypes, (SetMultimap<String, String>)excludedAttributes);
        includedWholeTypes.removeAll(excludedWholeTypes);
        includedAttributes.keySet().removeAll(includedWholeTypes);
        includedAttributes.keySet().removeAll(excludedWholeTypes);
        excludedAttributes.forEach((arg_0, arg_1) -> ((SetMultimap)includedAttributes).remove(arg_0, arg_1));
        excludedAttributes.keySet().removeAll(excludedWholeTypes);
        return new AnnotationAttributeMatcher(inclusions.isEmpty(), (ImmutableSet<String>)ImmutableSet.copyOf(inclusions.isPresent() ? includedWholeTypes : excludedWholeTypes), (ImmutableSetMultimap<String, String>)ImmutableSetMultimap.copyOf((Multimap)includedAttributes), (ImmutableSetMultimap<String, String>)ImmutableSetMultimap.copyOf((Multimap)excludedAttributes));
    }

    private static void update(Iterable<String> enumeration, Set<String> wholeTypes, SetMultimap<String, String> attributeRestrictions) {
        for (String entry : enumeration) {
            int hash = entry.indexOf(35);
            if (hash < 0) {
                wholeTypes.add(entry);
                continue;
            }
            String annotationType = entry.substring(0, hash);
            String attribute = entry.substring(hash + 1);
            attributeRestrictions.put((Object)annotationType, (Object)attribute);
        }
    }

    public Stream<ExpressionTree> extractMatchingArguments(AnnotationTree tree) {
        Type type = ASTHelpers.getType((Tree)tree.getAnnotationType());
        if (type == null) {
            return Stream.empty();
        }
        String annotationType = type.toString();
        return tree.getArguments().stream().map(ExpressionTree.class::cast).filter(a -> this.matches(annotationType, AnnotationAttributeMatcher.extractAttributeName(a)));
    }

    private static String extractAttributeName(ExpressionTree expr) {
        String string;
        if (expr instanceof AssignmentTree) {
            AssignmentTree assignment = (AssignmentTree)expr;
            string = ASTHelpers.getSymbol((Tree)assignment.getVariable()).getSimpleName().toString();
        } else {
            string = "value";
        }
        return string;
    }

    @VisibleForTesting
    boolean matches(String annotationType, String attribute) {
        if (this.complement) {
            return !this.wholeTypes.contains((Object)annotationType) && !this.excludedAttributes.containsEntry((Object)annotationType, (Object)attribute);
        }
        return this.wholeTypes.contains((Object)annotationType) && !this.excludedAttributes.containsEntry((Object)annotationType, (Object)attribute) || this.includedAttributes.containsEntry((Object)annotationType, (Object)attribute);
    }

    private static /* synthetic */ void lambda$create$0(Set includedWholeTypes, SetMultimap includedAttributes, List incl) {
        AnnotationAttributeMatcher.update(incl, includedWholeTypes, (SetMultimap<String, String>)includedAttributes);
    }
}

