/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.support.lint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ResourceLintReport<T> {
    static final String UNKNOWN_PATH = "UnknownFile";
    private Collection<T> lints = new ArrayList<T>();
    private String resourcePath = "UnknownFile";

    public ResourceLintReport() {
    }

    public static <T> ResourceLintReport<T> create(String resourcePath, Collection<T> lints) {
        return new ResourceLintReport<T>(resourcePath, lints);
    }

    private ResourceLintReport(String resourcePath, Collection<T> errors) {
        this.resourcePath = StringUtils.isEmpty((CharSequence)resourcePath) ? UNKNOWN_PATH : resourcePath;
        this.lints = this.filter(errors);
    }

    private List<T> filter(Collection<T> collection) {
        ArrayList<T> nullFreeList = new ArrayList<T>();
        if (collection != null) {
            for (T item : collection) {
                if (item == null) continue;
                nullFreeList.add(item);
            }
        }
        return nullFreeList;
    }

    public Collection<T> getLints() {
        return Collections.unmodifiableCollection(this.lints);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setLints(Collection<T> lints) {
        Validate.notNull(lints);
        this.lints = lints;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath == null ? UNKNOWN_PATH : resourcePath;
    }
}

