/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LoggerBridge;

public class BitbucketBuildServerData
extends BuildServerDataProvider {
    BitbucketBuildServerData(LoggerBridge log, @Nonnull Map<String, String> env) {
        super(log, env);
    }

    public static boolean isActiveServer(Map<String, String> env) {
        return env.containsKey("BITBUCKET_BUILD_NUMBER");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = Optional.ofNullable(this.env.get("BITBUCKET_BUILD_NUMBER")).orElse("");
        this.maybePut(properties, "build.number", () -> buildNumber);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedKey = null;
        String envKey = "BITBUCKET_BRANCH";
        String environmentBasedBranch = (String)this.env.get(envKey);
        if (environmentBasedBranch != null) {
            environmentBasedKey = envKey;
        }
        this.log.info("Using environment variable based branch name. {} = {}", (Object)environmentBasedKey, (Object)environmentBasedBranch);
        return environmentBasedBranch;
    }
}

