/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.ra;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddAdminObjectToRA
implements OnlineCommand {
    private final String poolName;
    private final String localJndiName;
    private final String className;
    private final String resourceAdapterId;
    private final boolean useJavaContext;
    private final Map<String, String> properties;

    private AddAdminObjectToRA(Builder builder) {
        this.poolName = builder.poolName;
        this.localJndiName = builder.localJndiName;
        this.className = builder.className;
        this.resourceAdapterId = builder.resourceAdapterId;
        this.useJavaContext = builder.useJavaContext;
        this.properties = builder.properties;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Batch batch = new Batch();
        Address address = Address.subsystem((String)"resource-adapters").and("resource-adapter", this.resourceAdapterId).and("admin-objects", this.poolName);
        batch.add(address, Values.of((String)"class-name", (String)this.className).and("jndi-name", this.localJndiName).and("use-java-context", this.useJavaContext));
        for (Map.Entry<String, String> pair : this.properties.entrySet()) {
            Address configPropsAddress = Address.subsystem((String)"resource-adapters").and("resource-adapter", this.resourceAdapterId).and("admin-objects", this.poolName).and("config-properties", pair.getKey());
            batch.add(configPropsAddress, Values.of((String)"value", (String)pair.getValue()));
        }
        new Operations(ctx.client).batch(batch);
    }

    public String toString() {
        return "AddAdminObjectToRA " + this.poolName;
    }

    public static final class Builder {
        private final String poolName;
        private final String localJndiName;
        private final String resourceAdapterId;
        private final Map<String, String> properties = new HashMap<String, String>();
        private String className;
        private boolean useJavaContext;

        public Builder(String poolName, String localJndiName, String resourceAdapterId) {
            if (poolName == null) {
                throw new IllegalArgumentException("poolName must be specified");
            }
            if (localJndiName == null) {
                throw new IllegalArgumentException("localJndiName must be specified");
            }
            if (resourceAdapterId == null) {
                throw new IllegalArgumentException("resourceAdapterId must be specified");
            }
            this.poolName = poolName;
            this.localJndiName = localJndiName;
            this.resourceAdapterId = resourceAdapterId;
        }

        public Builder addProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder setUseJavaContext(boolean useJavaContext) {
            this.useJavaContext = useJavaContext;
            return this;
        }

        public Builder setClassName(String className) {
            this.className = className;
            return this;
        }

        public AddAdminObjectToRA build() {
            if (this.className == null) {
                throw new IllegalArgumentException("className must be specified");
            }
            return new AddAdminObjectToRA(this);
        }
    }
}

