/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.AbstractLoggerCommand;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddLogger
extends AbstractLoggerCommand {
    private final boolean replaceExisting;

    private AddLogger(Builder builder) {
        super(builder);
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address loggerAddress = Address.subsystem((String)"logging").and("logger", this.category);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(loggerAddress);
            }
            catch (OperationException e) {
                throw new CommandFailedException("Failed to remove existing logger " + this.category, (Throwable)e);
            }
        }
        ops.add(loggerAddress, Values.empty().and("category", this.category).andOptional("level", this.level == null ? null : this.level.value()).andOptional("filter-spec", this.filter).andOptional("use-parent-handlers", this.useParentHandler).andListOptional(String.class, "handlers", this.handlers));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddLogger.class).subtree("logging", Subtree.subsystem("logging")).parameter("category", this.category).parameter("handlers", this.handlers).parameter("filter", this.filter).parameter("level", this.level == null ? null : this.level.value()).parameter("useParentHandler", this.useParentHandler == null ? null : String.valueOf(this.useParentHandler)).parameter("replaceExisting", this.replaceExisting).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "AddLogger " + this.category;
    }

    public static final class Builder
    extends AbstractLoggerCommand.Builder<Builder> {
        private boolean replaceExisting;

        public Builder(String category) {
            super(category);
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        @Override
        public AddLogger build() {
            return new AddLogger(this);
        }
    }
}

