/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class VaultXml {
    VaultXml() {
    }

    void parseVault(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        switch (expectedNs) {
            case DOMAIN_1_0: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: 
            case DOMAIN_1_4: 
            case DOMAIN_1_5: {
                this.parseVault_1_1(reader, address, expectedNs, list);
                break;
            }
            default: {
                if (expectedNs.getMajorVersion() == 2) {
                    this.parseVault_1_1(reader, address, expectedNs, list);
                    break;
                }
                this.parseVault_1_6_and_3_0(reader, address, expectedNs, list);
            }
        }
    }

    private void parseVault_1_1(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ServerLogger.CONFIG_LOGGER.vaultSupportRemoved();
    }

    private void parseVault_1_6_and_3_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case VAULT_OPTION: {
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ServerLogger.CONFIG_LOGGER.vaultSupportRemoved();
    }
}

