/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.rest.resource.urlsegments;

import java.util.Map;
import java.util.regex.Matcher;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.wicketstuff.rest.resource.urlsegments.AbstractURLSegment;

public class ParamSegment
extends AbstractURLSegment {
    private final String paramName = this.loadParamName();

    ParamSegment(String text) {
        super(text);
    }

    @Override
    public int calculateScore(String actualSegment) {
        Matcher matcher = this.getMetaPattern().matcher((CharSequence)actualSegment);
        return matcher.matches() ? 1 : 0;
    }

    private String loadParamName() {
        String segmentContent = this.toString();
        Matcher matcher = MetaPattern.VARIABLE_NAME.matcher((CharSequence)segmentContent);
        matcher.find();
        return matcher.group();
    }

    @Override
    protected MetaPattern loadMetaPattern() {
        String segmentContent = this.toString();
        int semicolonIndex = segmentContent.indexOf(58);
        if (semicolonIndex < 0) {
            return MetaPattern.ANYTHING_NON_EMPTY;
        }
        String regExp = segmentContent.substring(semicolonIndex + 1, segmentContent.length() - 1);
        Matcher matcher = REGEXP_BODY.matcher((CharSequence)regExp);
        matcher.matches();
        String group = matcher.group();
        return new MetaPattern(group);
    }

    @Override
    public void populatePathVariables(Map<String, String> variables, String segment) {
        Matcher matcher = this.getMetaPattern().matcher((CharSequence)segment);
        matcher.matches();
        variables.put(this.paramName, matcher.group());
    }

    public String getParamName() {
        return this.paramName;
    }
}

