/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.termination;

import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.TerminationCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stagnation
implements TerminationCondition {
    private final int generationLimit;
    private final boolean naturalFitness;
    private final boolean usePopulationAverage;
    private double bestFitness;
    private int fittestGeneration;

    public Stagnation(int generationLimit, boolean naturalFitness) {
        this(generationLimit, naturalFitness, false);
    }

    public Stagnation(int generationLimit, boolean naturalFitness, boolean usePopulationAverage) {
        this.generationLimit = generationLimit;
        this.naturalFitness = naturalFitness;
        this.usePopulationAverage = usePopulationAverage;
    }

    @Override
    public boolean shouldTerminate(PopulationData<?> populationData) {
        double fitness = this.getFitness(populationData);
        if (populationData.getGenerationNumber() == 0 || this.hasFitnessImproved(fitness)) {
            this.bestFitness = fitness;
            this.fittestGeneration = populationData.getGenerationNumber();
        }
        return populationData.getGenerationNumber() - this.fittestGeneration >= this.generationLimit;
    }

    private double getFitness(PopulationData<?> populationData) {
        return this.usePopulationAverage ? populationData.getMeanFitness() : populationData.getBestCandidateFitness();
    }

    private boolean hasFitnessImproved(double fitness) {
        return this.naturalFitness && fitness > this.bestFitness || !this.naturalFitness && fitness < this.bestFitness;
    }
}

