/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client.support;

import java.net.URI;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.service.invoker.AbstractReactorHttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebClientAdapter
extends AbstractReactorHttpExchangeAdapter {
    private final WebClient webClient;

    private WebClientAdapter(WebClient webClient) {
        this.webClient = webClient;
    }

    public boolean supportsRequestAttributes() {
        return true;
    }

    public Mono<Void> exchangeForMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().then();
    }

    public Mono<HttpHeaders> exchangeForHeadersMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().map(HttpEntity::getHeaders);
    }

    public <T> Mono<T> exchangeForBodyMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToMono(bodyType);
    }

    public <T> Flux<T> exchangeForBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToFlux(bodyType);
    }

    public Mono<ResponseEntity<Void>> exchangeForBodilessEntityMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity();
    }

    public <T> Mono<ResponseEntity<T>> exchangeForEntityMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntity(bodyType);
    }

    public <T> Mono<ResponseEntity<Flux<T>>> exchangeForEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntityFlux(bodyType);
    }

    private WebClient.RequestBodySpec newRequest(HttpRequestValues values) {
        ReactiveHttpRequestValues reactiveRequestValues;
        Publisher body2;
        WebClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = values.getHttpMethod();
        Assert.notNull((Object)httpMethod, (String)"HttpMethod is required");
        WebClient.RequestBodyUriSpec uriSpec = this.webClient.method(httpMethod);
        if (values.getUri() != null) {
            bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(values.getUri());
        } else if (values.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values.getUriBuilderFactory();
            if (uriBuilderFactory != null) {
                URI uri = uriBuilderFactory.expand(values.getUriTemplate(), values.getUriVariables());
                bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(uri);
            } else {
                bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(values.getUriTemplate(), values.getUriVariables());
            }
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        bodySpec.headers(headers -> headers.putAll((Map)values.getHeaders()));
        bodySpec.cookies(cookies -> cookies.putAll((Map)values.getCookies()));
        bodySpec.attributes(attributes -> attributes.putAll(values.getAttributes()));
        if (values.getBodyValue() != null) {
            bodySpec.bodyValue(values.getBodyValue());
        } else if (values instanceof ReactiveHttpRequestValues && (body2 = (reactiveRequestValues = (ReactiveHttpRequestValues)values).getBodyPublisher()) != null) {
            ParameterizedTypeReference elementType = reactiveRequestValues.getBodyPublisherElementType();
            Assert.notNull((Object)elementType, (String)"Publisher body element type is required");
            bodySpec.body((Object)body2, elementType);
        }
        return bodySpec;
    }

    public static WebClientAdapter create(WebClient webClient) {
        return new WebClientAdapter(webClient);
    }

    @Deprecated(since="6.1", forRemoval=true)
    public static WebClientAdapter forClient(WebClient webClient) {
        return new WebClientAdapter(webClient);
    }
}

