/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.Assert;

public class RequestResultMatchers {
    protected RequestResultMatchers() {
    }

    public ResultMatcher asyncStarted() {
        return result -> {
            MockHttpServletRequest request = result.getRequest();
            RequestResultMatchers.assertAsyncStarted(request);
        };
    }

    public ResultMatcher asyncNotStarted() {
        return result -> {
            MockHttpServletRequest request = result.getRequest();
            AssertionErrors.assertEquals("Async started", false, request.isAsyncStarted());
        };
    }

    public <T> ResultMatcher asyncResult(Matcher<T> matcher) {
        return result -> {
            MockHttpServletRequest request = result.getRequest();
            RequestResultMatchers.assertAsyncStarted(request);
            MatcherAssert.assertThat((String)"Async result", (Object)result.getAsyncResult(), (Matcher)matcher);
        };
    }

    public <T> ResultMatcher asyncResult(Object expectedResult) {
        return result -> {
            MockHttpServletRequest request = result.getRequest();
            RequestResultMatchers.assertAsyncStarted(request);
            AssertionErrors.assertEquals("Async result", expectedResult, result.getAsyncResult());
        };
    }

    public <T> ResultMatcher attribute(String name, Matcher<T> matcher) {
        return result -> {
            Object value = result.getRequest().getAttribute(name);
            MatcherAssert.assertThat((String)("Request attribute '" + name + "'"), (Object)value, (Matcher)matcher);
        };
    }

    public <T> ResultMatcher attribute(String name, Object expectedValue) {
        return result -> AssertionErrors.assertEquals("Request attribute '" + name + "'", expectedValue, result.getRequest().getAttribute(name));
    }

    public <T> ResultMatcher sessionAttribute(String name, Matcher<T> matcher) {
        return result -> {
            HttpSession session = result.getRequest().getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"No HttpSession");
            Object value = session.getAttribute(name);
            MatcherAssert.assertThat((String)("Session attribute '" + name + "'"), (Object)value, (Matcher)matcher);
        };
    }

    public <T> ResultMatcher sessionAttribute(String name, Object value) {
        return result -> {
            HttpSession session = result.getRequest().getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"No HttpSession");
            AssertionErrors.assertEquals("Session attribute '" + name + "'", value, session.getAttribute(name));
        };
    }

    private static void assertAsyncStarted(HttpServletRequest request) {
        AssertionErrors.assertEquals("Async started", true, request.isAsyncStarted());
    }
}

