/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ReflectionHelper {
    public static ArgumentsMatchInfo compareArguments(Class[] expectedArgTypes, Class[] suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes.length == suppliedArgTypes.length ? 1 : 0) != 0, (String)"Expected argument types and supplied argument types should be arrays of same length");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int i = 0;
        while (i < expectedArgTypes.length && match != null) {
            Class expectedArg = expectedArgTypes[i];
            Class suppliedArg = suppliedArgTypes[i];
            if (expectedArg != suppliedArg) {
                if (suppliedArg == null) {
                    if (expectedArg.isPrimitive()) {
                        match = null;
                    }
                } else if (ClassUtils.isAssignable((Class)expectedArg, (Class)suppliedArg)) {
                    if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                        match = ArgsMatchKind.CLOSE;
                    }
                } else if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList<Integer>();
                    }
                    argsRequiringConversion.add(i);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                } else {
                    match = null;
                }
            }
            ++i;
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            int i2 = 0;
            while (i2 < argsRequiringConversion.size()) {
                argsArray[i2] = (Integer)argsRequiringConversion.get(i2);
                ++i2;
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    public static ArgumentsMatchInfo compareArgumentsVarargs(Class[] expectedArgTypes, Class[] suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes != null && expectedArgTypes.length > 0 ? 1 : 0) != 0, (String)"Expected arguments must at least include one array (the vargargs parameter)");
        Assert.isTrue((boolean)expectedArgTypes[expectedArgTypes.length - 1].isArray(), (String)"Final expected argument should be array type (the varargs parameter)");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int argCountUpToVarargs = expectedArgTypes.length - 1;
        int i = 0;
        while (i < argCountUpToVarargs && match != null) {
            Class suppliedArg = suppliedArgTypes[i];
            Class expectedArg = expectedArgTypes[i];
            if (suppliedArg == null) {
                if (expectedArg.isPrimitive()) {
                    match = null;
                }
            } else if (expectedArg != suppliedArg) {
                if (expectedArg.isAssignableFrom(suppliedArg) || ClassUtils.isAssignableValue((Class)expectedArg, (Object)suppliedArg)) {
                    if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                        match = ArgsMatchKind.CLOSE;
                    }
                } else if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList<Integer>();
                    }
                    argsRequiringConversion.add(i);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                } else {
                    match = null;
                }
            }
            ++i;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.length != expectedArgTypes.length || expectedArgTypes[expectedArgTypes.length - 1] != suppliedArgTypes[suppliedArgTypes.length - 1]) {
            Class<?> varargsParameterType = expectedArgTypes[expectedArgTypes.length - 1].getComponentType();
            int i2 = expectedArgTypes.length - 1;
            while (i2 < suppliedArgTypes.length) {
                Class suppliedArg = suppliedArgTypes[i2];
                if (varargsParameterType != suppliedArg) {
                    if (suppliedArg == null) {
                        if (varargsParameterType.isPrimitive()) {
                            match = null;
                        }
                    } else if (ClassUtils.isAssignable(varargsParameterType, (Class)suppliedArg)) {
                        if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                            match = ArgsMatchKind.CLOSE;
                        }
                    } else if (typeConverter.canConvert(suppliedArg, varargsParameterType)) {
                        if (argsRequiringConversion == null) {
                            argsRequiringConversion = new ArrayList();
                        }
                        argsRequiringConversion.add(i2);
                        match = ArgsMatchKind.REQUIRES_CONVERSION;
                    } else {
                        match = null;
                    }
                }
                ++i2;
            }
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            int i3 = 0;
            while (i3 < argsRequiringConversion.size()) {
                argsArray[i3] = (Integer)argsRequiringConversion.get(i3);
                ++i3;
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    public static void convertArguments(Class[] requiredParameterTypes, boolean isVarargs, TypeConverter converter, int[] argumentsRequiringConversion, Object[] arguments) throws EvaluationException {
        Assert.notNull((Object)argumentsRequiringConversion, (String)"should not be called if no conversions required");
        Assert.notNull((Object)arguments, (String)"should not be called if no conversions required");
        Class<?> varargsType = null;
        if (isVarargs) {
            Assert.isTrue((boolean)requiredParameterTypes[requiredParameterTypes.length - 1].isArray(), (String)"if varargs then last parameter type must be array");
            varargsType = requiredParameterTypes[requiredParameterTypes.length - 1].getComponentType();
        }
        int[] nArray = argumentsRequiringConversion;
        int n = argumentsRequiringConversion.length;
        int n2 = 0;
        while (n2 < n) {
            Integer argPosition = nArray[n2];
            Class<?> targetType = null;
            targetType = isVarargs && argPosition >= requiredParameterTypes.length - 1 ? varargsType : requiredParameterTypes[argPosition];
            arguments[argPosition.intValue()] = converter.convertValue(arguments[argPosition], TypeDescriptor.valueOf(targetType));
            ++n2;
        }
    }

    public static void convertAllArguments(Class[] parameterTypes, boolean isVarargs, TypeConverter converter, Object[] arguments) throws SpelEvaluationException {
        Assert.notNull((Object)arguments, (String)"should not be called if nothing to convert");
        Class<?> varargsType = null;
        if (isVarargs) {
            Assert.isTrue((boolean)parameterTypes[parameterTypes.length - 1].isArray(), (String)"if varargs then last parameter type must be array");
            varargsType = parameterTypes[parameterTypes.length - 1].getComponentType();
        }
        int i = 0;
        while (i < arguments.length) {
            Class<?> targetType = null;
            targetType = isVarargs && i >= parameterTypes.length - 1 ? varargsType : parameterTypes[i];
            try {
                if (arguments[i] != null && arguments[i].getClass() != targetType) {
                    if (converter == null) {
                        throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, arguments[i].getClass().getName(), targetType);
                    }
                    arguments[i] = converter.convertValue(arguments[i], TypeDescriptor.valueOf(targetType));
                }
            }
            catch (EvaluationException ex) {
                if (ex instanceof SpelEvaluationException) {
                    throw (SpelEvaluationException)ex;
                }
                throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, arguments[i].getClass().getName(), targetType);
            }
            ++i;
        }
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class[] requiredParameterTypes, Object ... args) {
        int parameterCount = requiredParameterTypes.length;
        int argumentCount = args.length;
        if (parameterCount != args.length || requiredParameterTypes[parameterCount - 1] != (args[argumentCount - 1] == null ? null : args[argumentCount - 1].getClass())) {
            int arraySize = 0;
            if (argumentCount >= parameterCount) {
                arraySize = argumentCount - (parameterCount - 1);
            }
            Object[] repackagedArguments = (Object[])Array.newInstance(requiredParameterTypes[parameterCount - 1].getComponentType(), arraySize);
            int i = 0;
            while (i < arraySize) {
                repackagedArguments[i] = args[parameterCount + i - 1];
                ++i;
            }
            Object[] newArgs = new Object[parameterCount];
            int i2 = 0;
            while (i2 < newArgs.length - 1) {
                newArgs[i2] = args[i2];
                ++i2;
            }
            newArgs[newArgs.length - 1] = repackagedArguments;
            return newArgs;
        }
        return args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }

    public static class ArgumentsMatchInfo {
        public final ArgsMatchKind kind;
        public int[] argsRequiringConversion;

        ArgumentsMatchInfo(ArgsMatchKind kind, int[] integers) {
            this.kind = kind;
            this.argsRequiringConversion = integers;
        }

        ArgumentsMatchInfo(ArgsMatchKind kind) {
            this.kind = kind;
        }

        public boolean isExactMatch() {
            return this.kind == ArgsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgsMatchKind.REQUIRES_CONVERSION;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ArgumentMatch: ").append((Object)this.kind);
            if (this.argsRequiringConversion != null) {
                sb.append("  (argsForConversion:");
                int i = 0;
                while (i < this.argsRequiringConversion.length) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.argsRequiringConversion[i]);
                    ++i;
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

