/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.lang.annotation.Annotation;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKeyInvocationContext;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.jcache.interceptor.AbstractJCacheKeyOperation;
import org.springframework.cache.jcache.interceptor.CachePutOperation;
import org.springframework.cache.jcache.interceptor.DefaultCacheInvocationContext;

class DefaultCacheKeyInvocationContext<A extends Annotation>
extends DefaultCacheInvocationContext<A>
implements CacheKeyInvocationContext<A> {
    private final CacheInvocationParameter[] keyParameters;
    private final @Nullable CacheInvocationParameter valueParameter;

    public DefaultCacheKeyInvocationContext(AbstractJCacheKeyOperation<A> operation, Object target, @Nullable Object[] args) {
        super(operation, target, args);
        this.keyParameters = operation.getKeyParameters(args);
        if (operation instanceof CachePutOperation) {
            CachePutOperation cachePutOperation = (CachePutOperation)operation;
            this.valueParameter = cachePutOperation.getValueParameter(args);
        } else {
            this.valueParameter = null;
        }
    }

    public CacheInvocationParameter[] getKeyParameters() {
        return (CacheInvocationParameter[])this.keyParameters.clone();
    }

    public @Nullable CacheInvocationParameter getValueParameter() {
        return this.valueParameter;
    }
}

